/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.addons.activate;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import org.openecard.addon.AddonManager;
import org.openecard.addon.AddonNotFoundException;
import org.openecard.addon.Context;
import org.openecard.addon.bind.AppExtensionAction;
import org.openecard.addon.bind.AppPluginAction;
import org.openecard.addon.bind.Attachment;
import org.openecard.addon.bind.BindingResult;
import org.openecard.addon.bind.BindingResultCode;
import org.openecard.addon.bind.Headers;
import org.openecard.addon.bind.RequestBody;
import org.openecard.addon.manifest.AddonSpecification;
import org.openecard.binding.tctoken.TCTokenHandler;
import org.openecard.binding.tctoken.TCTokenRequest;
import org.openecard.binding.tctoken.TCTokenResponse;
import org.openecard.binding.tctoken.ex.ActivationError;
import org.openecard.binding.tctoken.ex.ErrorTranslations;
import org.openecard.binding.tctoken.ex.FatalActivationError;
import org.openecard.binding.tctoken.ex.NonGuiException;
import org.openecard.common.DynamicContext;
import org.openecard.common.I18n;
import org.openecard.common.OpenecardProperties;
import org.openecard.common.interfaces.Dispatcher;
import org.openecard.gui.UserConsent;
import org.openecard.gui.definition.ViewController;
import org.openecard.gui.message.DialogType;
import org.openecard.transport.httpcore.cookies.CookieManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivateAction
implements AppPluginAction {
    private static final Logger LOG = LoggerFactory.getLogger(ActivateAction.class);
    private static final Semaphore SEMAPHORE = new Semaphore(1);
    private final I18n lang = I18n.getTranslation("tr03112");
    private TCTokenHandler tokenHandler;
    private AppPluginAction statusAction;
    private AppExtensionAction pinManAction;
    private UserConsent gui;
    private AddonManager manager;
    private ViewController settingsAndDefaultView;
    private Dispatcher dispatcher;
    private Context ctx;

    @Override
    public void init(Context ctx) {
        this.tokenHandler = new TCTokenHandler(ctx);
        this.ctx = ctx;
        this.gui = ctx.getUserConsent();
        this.dispatcher = ctx.getDispatcher();
        this.manager = ctx.getManager();
        this.settingsAndDefaultView = ctx.getViewController();
        try {
            AddonSpecification addonSpecStatus = this.manager.getRegistry().search("Status");
            this.statusAction = this.manager.getAppPluginAction(addonSpecStatus, "getStatus");
            AddonSpecification addonSpecPinMngmt = this.manager.getRegistry().search("PIN-Plugin");
            this.pinManAction = this.manager.getAppExtensionAction(addonSpecPinMngmt, "GetCardsAndPINStatusAction");
        }
        catch (AddonNotFoundException ex) {
            String msg = "Failed to get Status or PIN Plugin.";
            LOG.error(msg, ex);
            throw new RuntimeException(msg, ex);
        }
    }

    @Override
    public void destroy() {
        this.tokenHandler = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BindingResult execute(RequestBody body, Map<String, String> params, Headers headers, List<Attachment> attachments) {
        BindingResult response;
        try {
            if (SEMAPHORE.tryAcquire()) {
                response = this.checkRequestParameters(body, params, headers, attachments);
            } else {
                response = new BindingResult(BindingResultCode.RESOURCE_LOCKED);
                response.setResultMessage("An authentication process is already running.");
            }
        }
        finally {
            SEMAPHORE.release();
            DynamicContext.remove();
        }
        return response;
    }

    private boolean isShowRemoveCard() {
        String str = OpenecardProperties.getProperty("notification.omit_show_remove_card");
        return Boolean.valueOf(str) == false;
    }

    private void showFinishMessage(TCTokenResponse response) {
        if ("http://www.bsi.bund.de/ecard/api/1.1/resultmajor#ok".equals(response.getResult().getResultMajor()) && this.isShowRemoveCard()) {
            String title = this.lang.translationForKey(ErrorTranslations.FINISH_TITLE, new Object[0]);
            String msg = this.lang.translationForKey(ErrorTranslations.REMOVE_CARD, new Object[0]);
            this.showBackgroundMessage(msg, title, DialogType.INFORMATION_MESSAGE);
        }
    }

    private void showBackgroundMessage(final String msg, final String title, final DialogType dialogType) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ActivateAction.this.gui.obtainMessageDialog().showMessageDialog(msg, title, dialogType);
            }
        }, "Background_MsgBox").start();
    }

    private void showErrorMessage(String errMsg) {
        String title = this.lang.translationForKey(ErrorTranslations.ERROR_TITLE, new Object[0]);
        String baseHeader = this.lang.translationForKey(ErrorTranslations.ERROR_HEADER, new Object[0]);
        String exceptionPart = this.lang.translationForKey(ErrorTranslations.ERROR_MSG_IND, new Object[0]);
        String removeCard = this.lang.translationForKey(ErrorTranslations.REMOVE_CARD, new Object[0]);
        String msg = String.format("%s\n\n%s\n%s\n\n%s", baseHeader, exceptionPart, errMsg, removeCard);
        this.showBackgroundMessage(msg, title, DialogType.ERROR_MESSAGE);
    }

    private BindingResult checkRequestParameters(RequestBody body, Map<String, String> params, Headers headers, List<Attachment> attachments) {
        boolean showUI = false;
        boolean status = false;
        boolean tokenUrl = false;
        boolean emptyParms = false;
        if (params.isEmpty()) {
            emptyParms = true;
        }
        if (params.containsKey("tcTokenURL")) {
            tokenUrl = true;
        }
        if (params.containsKey("Status")) {
            status = true;
        }
        if (params.containsKey("ShowUI")) {
            showUI = true;
        }
        if (emptyParms || !tokenUrl && !status && !showUI) {
            BindingResult response = new BindingResult(BindingResultCode.MISSING_PARAMETER);
            response.setResultMessage(this.lang.translationForKey(ErrorTranslations.NO_ACTIVATION_PARAMETERS, new Object[0]));
            this.showErrorMessage(this.lang.translationForKey(ErrorTranslations.NO_ACTIVATION_PARAMETERS, new Object[0]));
            return response;
        }
        if (tokenUrl && showUI || tokenUrl && status || showUI && status) {
            BindingResult response = new BindingResult(BindingResultCode.WRONG_PARAMETER);
            response.setResultMessage(this.lang.translationForKey(ErrorTranslations.NO_PARAMS, new Object[0]));
            this.showErrorMessage(this.lang.translationForKey(ErrorTranslations.NO_PARAMS, new Object[0]));
            return response;
        }
        return this.processRequest(body, params, headers, attachments, tokenUrl, showUI, status);
    }

    private BindingResult processRequest(RequestBody body, Map<String, String> params, Headers headers, List<Attachment> attachments, boolean tokenUrl, boolean showUI, boolean status) {
        BindingResult response = null;
        if (tokenUrl) {
            response = this.processTcToken(params);
            return response;
        }
        if (status) {
            response = this.processStatus(body, params, headers, attachments);
            return response;
        }
        if (showUI) {
            String requestedUI = params.get("ShowUI");
            response = this.processShowUI(requestedUI);
            return response;
        }
        return response;
    }

    private BindingResult processShowUI(String requestedUI) {
        BindingResult response;
        if (requestedUI != null) {
            switch (requestedUI) {
                case "Settings": {
                    response = this.processShowSettings();
                    break;
                }
                case "PINManagement": {
                    response = this.processShowPinManagement();
                    break;
                }
                default: {
                    response = this.processShowDefault();
                    break;
                }
            }
        } else {
            response = this.processShowDefault();
        }
        return response;
    }

    private BindingResult processShowDefault() {
        Thread defautlViewThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ActivateAction.this.settingsAndDefaultView.showDefaultViewUI();
            }
        }, "ShowDefaultView");
        defautlViewThread.start();
        return new BindingResult(BindingResultCode.OK);
    }

    private BindingResult processShowPinManagement() {
        Thread pinManThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ActivateAction.this.pinManAction.execute();
            }
        }, "ShowPINManagement");
        pinManThread.start();
        return new BindingResult(BindingResultCode.OK);
    }

    private BindingResult processShowSettings() {
        Thread settingsThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ActivateAction.this.settingsAndDefaultView.showSettingsUI();
            }
        }, "ShowSettings");
        settingsThread.start();
        return new BindingResult(BindingResultCode.OK);
    }

    private BindingResult processStatus(RequestBody body, Map<String, String> params, Headers headers, List<Attachment> attachments) {
        BindingResult response = this.statusAction.execute(body, params, headers, attachments);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BindingResult processTcToken(Map<String, String> params) {
        BindingResult response;
        DynamicContext dynCtx = DynamicContext.getInstance("tr03112");
        dynCtx.put("cookie_mananger", new CookieManager());
        try {
            TCTokenRequest tcTokenRequest = null;
            try {
                tcTokenRequest = TCTokenRequest.convert(params, this.ctx);
                response = this.tokenHandler.handleActivate(tcTokenRequest);
                this.showFinishMessage((TCTokenResponse)response);
            }
            catch (ActivationError ex) {
                if (!(ex instanceof NonGuiException)) {
                    if (ex.getMessage().equals("Invalid HTTP message received.")) {
                        this.showErrorMessage(this.lang.translationForKey(ErrorTranslations.ACTIVATION_INVALID_REFRESH_ADDRESS, new Object[0]));
                    } else {
                        this.showErrorMessage(ex.getLocalizedMessage());
                    }
                }
                LOG.error(ex.getMessage());
                LOG.debug(ex.getMessage(), ex);
                LOG.debug("Returning result: \n{}", (Object)ex.getBindingResult());
                if (ex instanceof FatalActivationError) {
                    LOG.info("Authentication failed, displaying error in Browser.");
                } else {
                    LOG.info("Authentication failed, redirecting to with errors attached to the URL.");
                }
                response = ex.getBindingResult();
            }
            finally {
                if (tcTokenRequest != null && tcTokenRequest.getTokenContext() != null) {
                    tcTokenRequest.getTokenContext().closeStream();
                }
            }
        }
        catch (RuntimeException e) {
            response = new BindingResult(BindingResultCode.INTERNAL_ERROR);
            LOG.error(e.getMessage(), e);
        }
        return response;
    }
}

