/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.addon.manifest;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.openecard.addon.manifest.AttachmentType;
import org.openecard.addon.manifest.BodyType;
import org.openecard.addon.manifest.Configuration;
import org.openecard.addon.manifest.LocalizedString;
import org.openecard.addon.manifest.ParameterType;
import org.openecard.addon.utils.LocalizedStringExtractor;

@XmlRootElement(name="AppPluginSpecification")
@XmlType(propOrder={"className", "loadOnStartup", "localizedName", "localizedDescription", "resourceName", "configDescription", "parameters", "body", "attachments"})
@XmlAccessorType(value=XmlAccessType.FIELD)
public class AppPluginSpecification {
    @XmlElement(name="ClassName")
    private String className;
    @XmlElement(name="LoadOnStartup", required=false, defaultValue="false")
    private Boolean loadOnStartup;
    @XmlElement(name="LocalizedName")
    private final List<LocalizedString> localizedName = new ArrayList<LocalizedString>();
    @XmlElement(name="LocalizedDescription")
    private final List<LocalizedString> localizedDescription = new ArrayList<LocalizedString>();
    @XmlElement(name="ConfigDescription")
    private Configuration configDescription;
    @XmlElement(name="Parameter")
    private final List<ParameterType> parameters = new ArrayList<ParameterType>();
    @XmlElement(name="ResourceName")
    private String resourceName;
    @XmlElement(name="Body")
    private BodyType body;
    @XmlElement(name="Attachment")
    private final List<AttachmentType> attachments = new ArrayList<AttachmentType>();

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public Boolean isLoadOnStartup() {
        if (this.loadOnStartup == null) {
            return false;
        }
        return this.loadOnStartup;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public List<LocalizedString> getLocalizedName() {
        return this.localizedName;
    }

    public List<LocalizedString> getLocalizedDescription() {
        return this.localizedDescription;
    }

    public Configuration getConfigDescription() {
        return this.configDescription;
    }

    public void setLoadOnStartup(Boolean loadOnStartup) {
        this.loadOnStartup = loadOnStartup;
    }

    public void setConfigDescription(Configuration configDescription) {
        this.configDescription = configDescription;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public void setBody(BodyType body) {
        this.body = body;
    }

    public BodyType getBody() {
        return this.body;
    }

    public List<ParameterType> getParameters() {
        return this.parameters;
    }

    public List<AttachmentType> getAttachments() {
        return this.attachments;
    }

    public String getLocalizedName(String languageCode) {
        return LocalizedStringExtractor.getLocalizedString(this.localizedName, languageCode);
    }

    public String getLocalizedDescription(String languageCode) {
        return LocalizedStringExtractor.getLocalizedString(this.localizedDescription, languageCode);
    }
}

