/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.addon;

import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openecard.addon.SelectionStrategy;
import org.openecard.addon.manifest.AddonSpecification;

public class HighestVersionSelector
implements SelectionStrategy {
    @Override
    public AddonSpecification select(Set<AddonSpecification> addons) {
        TreeSet<AddonSpecification> specs = new TreeSet<AddonSpecification>(new VersionComparator());
        for (AddonSpecification spec : addons) {
            specs.add(spec);
        }
        return specs.last();
    }

    private class SemanticVersion {
        private final int major;
        private final int minor;
        private final int patch;
        private final String addLabel;
        private final boolean isSemVersion;

        private SemanticVersion(String version) {
            String[] groups = new String[4];
            Pattern p = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)(-.+)?");
            Matcher m = p.matcher(version);
            if (m.matches() && m.groupCount() >= 3) {
                groups[0] = m.group(1);
                groups[1] = m.group(2);
                groups[2] = m.group(3);
                groups[3] = m.group(4);
                if (groups[3] != null) {
                    groups[3] = groups[3].substring(1);
                }
                this.major = Integer.parseInt(groups[0]);
                this.minor = Integer.parseInt(groups[1]);
                this.patch = Integer.parseInt(groups[2]);
                this.addLabel = groups[3];
                this.isSemVersion = true;
            } else {
                this.major = 0;
                this.minor = 0;
                this.patch = 0;
                this.addLabel = null;
                this.isSemVersion = false;
            }
        }

        private int getMajor() {
            return this.major;
        }

        private int getMinor() {
            return this.minor;
        }

        private int getPatch() {
            return this.patch;
        }

        private String getAddLabel() {
            return this.addLabel;
        }

        private boolean isSemanticVersion() {
            return this.isSemVersion;
        }
    }

    private class VersionComparator
    implements Comparator<AddonSpecification> {
        private VersionComparator() {
        }

        @Override
        public int compare(AddonSpecification o1, AddonSpecification o2) {
            int result = 0;
            if (o1 == null && o2 == null) {
                throw new NullPointerException("Can't compare two NULL elements.");
            }
            if (o1 == null && o2 != null) {
                return -1;
            }
            if (o1 != null && o2 == null) {
                return 1;
            }
            SemanticVersion semVer1 = new SemanticVersion(o1.getVersion());
            SemanticVersion semVer2 = new SemanticVersion(o2.getVersion());
            result = semVer1.isSemanticVersion() && semVer2.isSemanticVersion() ? this.compareSemanticVersions(semVer1, semVer2) : (semVer1.isSemanticVersion() ? 1 : (semVer2.isSemanticVersion() ? -1 : o1.getVersion().compareTo(o2.getVersion())));
            return result;
        }

        private int compareSemanticVersions(SemanticVersion v1, SemanticVersion v2) {
            if (this.compareIntNums(v1.getMajor(), v2.getMajor()) != 0) {
                return this.compareIntNums(v1.getMajor(), v2.getMajor());
            }
            if (this.compareIntNums(v1.getMinor(), v2.getMinor()) != 0) {
                return this.compareIntNums(v1.getMinor(), v2.getMinor());
            }
            if (this.compareIntNums(v1.getPatch(), v2.getPatch()) != 0) {
                return this.compareIntNums(v1.getPatch(), v2.getPatch());
            }
            if (v1.getAddLabel() != null && v2.getAddLabel() == null) {
                return -1;
            }
            if (v1.getAddLabel() == null && v2.getAddLabel() != null) {
                return 1;
            }
            if (v1.getAddLabel() == null && v2.getAddLabel() == null) {
                return 0;
            }
            return v1.getAddLabel().compareTo(v2.getAddLabel());
        }

        private int compareIntNums(int value1, int value2) {
            int result = -2;
            result = value1 == value2 ? 0 : (value1 > value2 ? 1 : -1);
            return result;
        }
    }
}

