/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.addon;

import org.openecard.addon.AddonManager;
import org.openecard.addon.AddonProperties;
import org.openecard.addon.EventHandler;
import org.openecard.addon.manifest.AddonSpecification;
import org.openecard.addon.sal.CredentialManager;
import org.openecard.common.interfaces.CardRecognition;
import org.openecard.common.interfaces.Dispatcher;
import org.openecard.common.interfaces.EventDispatcher;
import org.openecard.common.sal.state.CardStateMap;
import org.openecard.gui.UserConsent;
import org.openecard.gui.definition.ViewController;

public class Context {
    private final AddonProperties addonProperties;
    private final AddonManager manager;
    private final Dispatcher dispatcher;
    private final EventDispatcher eventDispatcher;
    private final String id;
    private final ViewController viewController;
    private CredentialManager credMan;
    private UserConsent userConsent;
    private CardStateMap cardStates;
    private CardRecognition recognition;
    private EventHandler eventHandler;

    public Context(AddonManager manager, Dispatcher dispatcher, EventDispatcher eventManager, AddonSpecification spec, ViewController addView) {
        this.manager = manager;
        this.dispatcher = dispatcher;
        this.eventDispatcher = eventManager;
        this.id = spec.getId();
        this.addonProperties = new AddonProperties(spec);
        this.viewController = addView;
    }

    public void setCardRecognition(CardRecognition cardRec) {
        this.recognition = cardRec;
    }

    public void setEventHandle(EventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    public void setCardStateMap(CardStateMap cardStates) {
        this.cardStates = cardStates;
        this.credMan = new CredentialManager(cardStates);
    }

    public void setUserConsent(UserConsent uConsent) {
        this.userConsent = uConsent;
    }

    public AddonManager getManager() {
        return this.manager;
    }

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public EventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    public UserConsent getUserConsent() {
        return this.userConsent;
    }

    public AddonProperties getAddonProperties() {
        return this.addonProperties;
    }

    public ViewController getViewController() {
        return this.viewController;
    }

    @Deprecated
    public CardStateMap getCardStates() {
        return this.cardStates;
    }

    public CardRecognition getRecognition() {
        return this.recognition;
    }

    public EventHandler getEventHandler() {
        return this.eventHandler;
    }

    public CredentialManager getCredentialManager() {
        return this.credMan;
    }

    public String getId() {
        return this.id;
    }
}

