/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.addon;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.openecard.addon.AddonPropertiesException;
import org.openecard.addon.manifest.AddonSpecification;
import org.openecard.common.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddonProperties {
    private static final Logger logger = LoggerFactory.getLogger(AddonProperties.class);
    private static final String FILE_EXTENSION = ".conf";
    private final String id;
    private File configFile;
    private final AddonSpecification addonSpec;
    private final Properties props = new Properties();

    public AddonProperties(AddonSpecification addonSpecification) {
        this.addonSpec = addonSpecification;
        this.id = this.addonSpec.getId();
        try {
            this.configFile = new File(FileUtils.getAddonsConfDir(), this.id + "/" + this.id + FILE_EXTENSION);
        }
        catch (IOException ex) {
            logger.error("Couldn't create file object to the config directory.", ex);
        }
        catch (SecurityException ex) {
            String msg = "SecurityException seems like you do not have enough permissions to create a file object for the config directory.";
            logger.error(msg, ex);
        }
    }

    public void loadProperties() throws AddonPropertiesException {
        if (this.configFile.exists()) {
            try {
                this.props.load(new FileInputStream(this.configFile));
            }
            catch (IOException ex) {
                logger.error("Failed to load properties for the addon with the ID " + this.id + ".", ex);
                throw new AddonPropertiesException("Failed to load properties for the addon with the ID " + this.id + ".", ex);
            }
        } else {
            logger.warn("Can't load the properties of the addon with the ID " + this.id + ". The file containing the properties does not exist.");
        }
    }

    public void saveProperties() throws AddonPropertiesException {
        try {
            File addonDir = new File(FileUtils.getAddonsConfDir(), this.id);
            if (!addonDir.exists() && !addonDir.mkdirs()) {
                logger.error(this.id);
            }
            FileOutputStream out = new FileOutputStream(this.configFile, false);
            this.props.store(out, "Configuration file of the " + this.id + "addon.");
        }
        catch (FileNotFoundException ex) {
            String msg = "Failed to save the properties for the addon with the ID " + this.id + ". The file was not found.The settings aren't stored.";
            logger.error(msg, ex);
            throw new AddonPropertiesException(msg, ex);
        }
        catch (IOException ex) {
            String msg = "Failed to save the properties for the addon with the ID " + this.id + ". The settings aren't stored.";
            logger.error(msg, ex);
            throw new AddonPropertiesException(msg, ex);
        }
    }

    public void setProperty(String key, String value) {
        this.props.setProperty(key, value);
    }

    public String getProperty(String key) {
        return this.props.getProperty(key);
    }

    protected void removeConfiguration() {
        try {
            File confDir = new File(FileUtils.getAddonsConfDir(), this.id);
            this.removeDirectory(confDir);
        }
        catch (IOException ex) {
            logger.error("Failed to get the Addon configuration directory.", ex);
        }
        catch (SecurityException ex) {
            logger.error("Failed to access the Addon configuration directory.", ex);
        }
        this.configFile.delete();
    }

    private void removeDirectory(File directoryToRemove) {
        String[] files;
        for (String item : files = directoryToRemove.list()) {
            File fileItem = new File(directoryToRemove, item);
            if (fileItem.isFile()) {
                fileItem.delete();
                continue;
            }
            this.removeDirectory(fileItem);
            fileItem.delete();
        }
    }
}

