/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.addon;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.openecard.addon.ActionInitializationException;
import org.openecard.addon.Context;
import org.openecard.addon.LifecycleTrait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractFactory<C extends LifecycleTrait> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractFactory.class);
    private final String implClass;
    private ClassLoader classLoader;

    public AbstractFactory(String implClass, ClassLoader classLoader) {
        this.implClass = implClass;
        this.classLoader = classLoader;
    }

    protected C loadInstance(Context ctx, Class<C> clazz) throws ActionInitializationException {
        try {
            Class<?> classToLoad = this.classLoader.loadClass(this.implClass);
            Class<C> typedClass = classToLoad.asSubclass(clazz);
            Constructor<C> ctor = typedClass.getConstructor(new Class[0]);
            ctor.setAccessible(true);
            LifecycleTrait c = (LifecycleTrait)typedClass.cast(ctor.newInstance(new Object[0]));
            c.init(ctx);
            return (C)c;
        }
        catch (InstantiationException e) {
            logger.error("Given class could not be instantiated.", e);
            throw new ActionInitializationException(e);
        }
        catch (InvocationTargetException e) {
            logger.error("Exception in nullary constructor of given class.", e);
            throw new ActionInitializationException(e);
        }
        catch (IllegalAccessException e) {
            logger.error("The class or its nullary constructor is not accessible.", e);
            throw new ActionInitializationException(e);
        }
        catch (ClassNotFoundException e) {
            logger.error("Given class could not be found.", e);
            throw new ActionInitializationException(e);
        }
        catch (ClassCastException e) {
            logger.error("Given class does not extend FactoryBaseType.", e);
            throw new ActionInitializationException(e);
        }
        catch (NoSuchMethodException e) {
            logger.error("Default constructor does not exist in action implementation.", e);
            throw new ActionInitializationException(e);
        }
    }
}

