/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.plugins.pinplugin.gui;

import org.openecard.common.I18n;
import org.openecard.gui.definition.PasswordField;
import org.openecard.gui.definition.Step;
import org.openecard.gui.definition.Text;

public class ChangePINStep
extends Step {
    private final I18n lang = I18n.getTranslation("pinplugin");
    private static final String PINSTEP_NEWPINREPEAT = "action.changepin.userconsent.pinstep.newpinrepeat";
    private static final String PINSTEP_NEWPIN = "action.changepin.userconsent.pinstep.newpin";
    private static final String PINSTEP_OLDPIN = "action.changepin.userconsent.pinstep.oldpin";
    private static final String PINSTEP_DESCRIPTION = "action.changepin.userconsent.pinstep.description";
    private static final String PINSTEP_NATIVE_DESCRIPTION = "action.changepin.userconsent.pinstep.native_description";
    private static final String UNBLOCKING_REQUIRED = "action.changepin.userconsent.pinstep.unblocking_required";
    private static final String REMAINING_ATTEMPTS = "action.changepin.userconsent.pinstep.remaining_attempts";
    private static final String WRONG_ENTRY = "action.changepin.userconsent.pinstep.wrong_entry";
    private static final String INCORRECT_INPUT = "action.changepin.userconsent.pinstep.incorrect_input";
    public static final String OLD_PIN_FIELD = "OLD_PIN_FIELD";
    public static final String NEW_PIN_FIELD = "NEW_PIN_FIELD";
    public static final String NEW_PIN_REPEAT_FIELD = "NEW_PIN_REPEAT_FIELD";

    public ChangePINStep(String id, String title, boolean capturePin, int retryCounter, boolean enteredWrong, boolean verifyFailed) {
        super(id, title);
        this.setReversible(false);
        if (retryCounter < 1) {
            Text description = new Text();
            description.setText(this.lang.translationForKey(UNBLOCKING_REQUIRED, new Object[0]));
            this.getInputInfoUnits().add(description);
            return;
        }
        Text i1 = new Text();
        this.getInputInfoUnits().add(i1);
        if (!capturePin) {
            this.setInstantReturn(true);
            i1.setText(this.lang.translationForKey(PINSTEP_NATIVE_DESCRIPTION, new Object[0]));
        } else {
            i1.setText(this.lang.translationForKey(PINSTEP_DESCRIPTION, new Object[0]));
            PasswordField oldPIN = new PasswordField(OLD_PIN_FIELD);
            oldPIN.setDescription(this.lang.translationForKey(PINSTEP_OLDPIN, new Object[0]));
            this.getInputInfoUnits().add(oldPIN);
            PasswordField newPIN = new PasswordField(NEW_PIN_FIELD);
            newPIN.setDescription(this.lang.translationForKey(PINSTEP_NEWPIN, new Object[0]));
            this.getInputInfoUnits().add(newPIN);
            PasswordField newPINRepeat = new PasswordField(NEW_PIN_REPEAT_FIELD);
            newPINRepeat.setDescription(this.lang.translationForKey(PINSTEP_NEWPINREPEAT, new Object[0]));
            this.getInputInfoUnits().add(newPINRepeat);
        }
        if (enteredWrong) {
            Text noteWrongEntry = new Text();
            noteWrongEntry.setText(this.lang.translationForKey(WRONG_ENTRY, new Object[0]));
            this.getInputInfoUnits().add(noteWrongEntry);
        }
        if (verifyFailed) {
            Text incorrectInput = new Text();
            incorrectInput.setText(this.lang.translationForKey(INCORRECT_INPUT, new Object[0]));
            this.getInputInfoUnits().add(incorrectInput);
        }
        if (retryCounter < 3) {
            Text txtRemainingAttempts = new Text();
            txtRemainingAttempts.setText(this.lang.translationForKey(REMAINING_ATTEMPTS, retryCounter));
            this.getInputInfoUnits().add(txtRemainingAttempts);
        }
    }
}

