/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.ifd.scio.reader;

import java.util.Arrays;
import oasis.names.tc.dss._1_0.core.schema.Result;
import org.openecard.common.WSHelper;
import org.openecard.common.apdu.common.CardCommandStatus;
import org.openecard.common.util.ByteUtils;

public class ExecutePACEResponse {
    final int result;
    final short length;
    final byte[] data;

    public ExecutePACEResponse(byte[] response) {
        this.result = ByteUtils.toInteger(Arrays.copyOfRange(response, 0, 4));
        this.length = ByteUtils.toShort(new byte[]{response[5], response[4]});
        this.data = Arrays.copyOfRange(response, 6, 6 + this.length);
    }

    public boolean isError() {
        return this.result != 0;
    }

    public int getResultCode() {
        return this.result;
    }

    public Result getResult() {
        if (this.result == 0) {
            return WSHelper.makeResultOK();
        }
        if (this.result == -805306367) {
            return WSHelper.makeResultUnknownError("Inconsistent lengths in input.");
        }
        if (this.result == -805306366) {
            return WSHelper.makeResultUnknownError("Unexpected data in input.");
        }
        if (this.result == -805306365) {
            return WSHelper.makeResultUnknownError("Unexpected combination of data in input.");
        }
        if (this.result == -536870911) {
            return WSHelper.makeResultUnknownError("Syntax error in TLV response.");
        }
        if (this.result == -536870910) {
            return WSHelper.makeResultUnknownError("Unexpected or missing object in TLV response.");
        }
        if (this.result == -536870909) {
            return WSHelper.makeResultUnknownError("Unknown PIN-ID.");
        }
        if (this.result == -536870906) {
            return WSHelper.makeResultUnknownError("Wrong Authentication Token.");
        }
        if ((this.result & 0xFFFC0000) == -268435456) {
            byte[] sw = new byte[]{(byte)(this.result >> 8 & 0xFF), (byte)(this.result & 0xFF)};
            String msg = CardCommandStatus.getMessage(sw);
            int type = this.result >> 16 & 0xFFFF;
            if (type == 61440) {
                return WSHelper.makeResultUnknownError("Select EF.CardAccess: " + msg);
            }
            if (type == 61441) {
                return WSHelper.makeResultUnknownError("Read Binary EF.CardAccess: " + msg);
            }
            if (type == 61442) {
                return WSHelper.makeResultUnknownError("MSE Set AT: " + msg);
            }
            if (type == 61443) {
                return WSHelper.makeResultUnknownError("General Authenticat Step 1-4: " + msg);
            }
        }
        if (this.result == -267386879) {
            return WSHelper.makeResultUnknownError("Communication abort.");
        }
        if (this.result == -267386878) {
            return WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/terminal#noCard", "No card.");
        }
        if (this.result == -266338303) {
            return WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl#cancellationByUser", "Abort.");
        }
        if (this.result == -266338302) {
            return WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/common#timeoutError", "Timeout.");
        }
        return WSHelper.makeResultUnknownError(null);
    }

    public byte[] getData() {
        return this.data;
    }
}

