/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.gui.definition;

import java.util.Arrays;
import org.openecard.gui.definition.IDTrait;
import org.openecard.gui.definition.InfoUnit;
import org.openecard.gui.definition.InfoUnitElementType;
import org.openecard.gui.definition.InputInfoUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ImageBox
extends IDTrait
implements InputInfoUnit {
    private static final Logger logger = LoggerFactory.getLogger(ImageBox.class);
    private byte[] imageData;
    private String mimeType;

    public byte[] getImageData() {
        return Arrays.copyOf(this.imageData, this.imageData.length);
    }

    public void setImageData(byte[] imageData) {
        this.imageData = Arrays.copyOf(imageData, imageData.length);
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    @Override
    public InfoUnitElementType type() {
        return InfoUnitElementType.IMAGE_BOX;
    }

    @Override
    public void copyContentFrom(InfoUnit origin) {
        if (!this.getClass().equals(origin.getClass())) {
            logger.warn("Trying to copy content from type {} to type {}.", (Object)origin.getClass(), (Object)this.getClass());
            return;
        }
        ImageBox other = (ImageBox)origin;
        if (other.imageData != null) {
            this.imageData = Arrays.copyOf(other.imageData, other.imageData.length);
        }
        this.mimeType = other.mimeType;
    }
}

