/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.common.asn1.cvc;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.openecard.common.tlv.TLV;
import org.openecard.common.tlv.TLVException;
import org.openecard.common.tlv.TagClass;
import org.openecard.common.util.ByteUtils;
import org.openecard.crypto.common.asn1.utils.ObjectIdentifierUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CHAT {
    private static final Logger _logger = LoggerFactory.getLogger(CHAT.class);
    private String oid;
    private Role role;
    private byte[] discretionaryData;
    private TreeMap<DataGroup, Boolean> writeAccess = new TreeMap<DataGroup, Boolean>(){
        {
            DataGroup[] data = DataGroup.values();
            for (int i = 16; i < 21; ++i) {
                this.put(data[i], false);
            }
        }
    };
    private TreeMap<DataGroup, Boolean> readAccess = new TreeMap<DataGroup, Boolean>(){
        {
            DataGroup[] data = DataGroup.values();
            for (int i = 0; i < 21; ++i) {
                this.put(data[i], false);
            }
        }
    };
    private TreeMap<SpecialFunction, Boolean> specialFunctions = new TreeMap<SpecialFunction, Boolean>(){
        {
            SpecialFunction[] data = SpecialFunction.values();
            for (int i = 0; i < data.length; ++i) {
                this.put(data[i], false);
            }
        }
    };
    private TreeMap<AccessRight, Boolean> accessRights = new TreeMap<AccessRight, Boolean>(){
        {
            AccessRight[] data = AccessRight.values();
            for (int i = 0; i < data.length; ++i) {
                this.put(data[i], false);
            }
        }
    };

    public CHAT(byte[] chat) throws TLVException {
        this(TLV.fromBER(chat));
    }

    public CHAT(TLV tlv) throws TLVException {
        this.oid = ObjectIdentifierUtils.toString(tlv.findChildTags(6L).get(0).getValue());
        this.discretionaryData = tlv.findChildTags(83L).get(0).getValue();
        if (this.oid.equals("0.4.0.127.0.7.3.1.2.1")) {
            this.parseRole(this.discretionaryData[0]);
            this.parseAccessRights(this.discretionaryData[0]);
        } else if (this.oid.equals("0.4.0.127.0.7.3.1.2.2")) {
            this.parseRole(this.discretionaryData[0]);
            this.parseWriteAccess(this.discretionaryData);
            this.parseReadAccess(this.discretionaryData);
            this.parseSpecialFunctions(this.discretionaryData);
        } else if (this.oid.equals("0.4.0.127.0.7.3.1.2.3")) {
            this.parseRole(this.discretionaryData[0]);
            this.parseAccessRights(this.discretionaryData[0]);
        }
    }

    private void parseRole(byte roleByte) {
        roleByte = (byte)(roleByte & 0xFFFFFFC0);
        switch (roleByte) {
            case -64: {
                this.role = Role.CVCA;
                break;
            }
            case -128: {
                this.role = Role.DV_OFFICIAL;
                break;
            }
            case 64: {
                this.role = Role.DV_NON_OFFICIAL;
                break;
            }
            case 0: {
                if (this.oid.equals("0.4.0.127.0.7.3.1.2.1")) {
                    this.role = Role.INSPECTION_TERMINAL;
                    break;
                }
                if (this.oid.equals("0.4.0.127.0.7.3.1.2.2")) {
                    this.role = Role.AUTHENTICATION_TERMINAL;
                    break;
                }
                if (!this.oid.equals("0.4.0.127.0.7.3.1.2.3")) break;
                this.role = Role.SIGNATURE_TERMINAL;
                break;
            }
        }
    }

    private void parseAccessRights(byte accessRightsByte) {
        if (this.role.equals((Object)Role.INSPECTION_TERMINAL)) {
            if (ByteUtils.isBitSet(6, new byte[]{accessRightsByte})) {
                this.accessRights.put(AccessRight.DG04, Boolean.TRUE);
            }
            if (ByteUtils.isBitSet(7, new byte[]{accessRightsByte})) {
                this.accessRights.put(AccessRight.DG03, Boolean.TRUE);
            }
        } else if (this.role.equals((Object)Role.SIGNATURE_TERMINAL)) {
            if (ByteUtils.isBitSet(6, new byte[]{accessRightsByte})) {
                this.accessRights.put(AccessRight.GENERATE_QUALIFIED_SIGNATURE, Boolean.TRUE);
            }
            if (ByteUtils.isBitSet(7, new byte[]{accessRightsByte})) {
                this.accessRights.put(AccessRight.GENERATE_SIGNATURE, Boolean.TRUE);
            }
        }
    }

    private void parseWriteAccess(byte[] discretionaryData) {
        Iterator<DataGroup> it = this.writeAccess.keySet().iterator();
        for (int i = 2; i < 6; ++i) {
            DataGroup item = it.next();
            this.writeAccess.put(item, ByteUtils.isBitSet(i, discretionaryData));
        }
    }

    private void parseReadAccess(byte[] discretionaryData) {
        Iterator<DataGroup> it = this.readAccess.keySet().iterator();
        for (int i = 31; i > 11; --i) {
            DataGroup item = it.next();
            this.readAccess.put(item, ByteUtils.isBitSet(i, discretionaryData));
        }
    }

    private void parseSpecialFunctions(byte[] discretionaryData) {
        Iterator<SpecialFunction> it = this.specialFunctions.keySet().iterator();
        for (int i = 32; i < 40; ++i) {
            SpecialFunction item = it.next();
            this.specialFunctions.put(item, ByteUtils.isBitSet(i, discretionaryData));
        }
    }

    public Role getRole() {
        return this.role;
    }

    public TreeMap<DataGroup, Boolean> getWriteAccess() {
        return this.writeAccess;
    }

    public boolean setWriteAccess(DataGroup dataGroup, boolean selected) {
        if (this.writeAccess.containsKey((Object)dataGroup)) {
            this.writeAccess.put(dataGroup, selected);
            return true;
        }
        return false;
    }

    public boolean setWriteAccess(String dataGroup, boolean selected) {
        return this.setWriteAccess(DataGroup.valueOf(dataGroup), selected);
    }

    public void setWriteAccess(TreeMap<DataGroup, Boolean> writeAccess) {
        for (DataGroup item : this.writeAccess.keySet()) {
            this.writeAccess.put(item, writeAccess.get((Object)item));
        }
    }

    public TreeMap<DataGroup, Boolean> getReadAccess() {
        return this.readAccess;
    }

    public boolean setReadAccess(DataGroup dataGroup, boolean selected) {
        if (this.readAccess.containsKey((Object)dataGroup)) {
            this.readAccess.put(dataGroup, selected);
            return true;
        }
        return false;
    }

    public boolean setReadAccess(String dataGroup, boolean selected) {
        return this.setReadAccess(DataGroup.valueOf(dataGroup), selected);
    }

    public void setReadAccess(TreeMap<DataGroup, Boolean> readAccess) {
        for (DataGroup item : this.readAccess.keySet()) {
            this.readAccess.put(item, readAccess.get((Object)item));
        }
    }

    public TreeMap<SpecialFunction, Boolean> getSpecialFunctions() {
        return this.specialFunctions;
    }

    public boolean setSpecialFunctions(SpecialFunction specialFunction, boolean selected) {
        if (this.specialFunctions.containsKey((Object)specialFunction)) {
            this.specialFunctions.put(specialFunction, selected);
            return true;
        }
        return false;
    }

    public boolean setSpecialFunction(String specialFunction, boolean selected) {
        return this.setSpecialFunctions(SpecialFunction.valueOf(specialFunction), selected);
    }

    public void setSpecialFunctions(TreeMap<SpecialFunction, Boolean> specialFunctions) {
        for (SpecialFunction item : this.specialFunctions.keySet()) {
            this.specialFunctions.put(item, specialFunctions.get((Object)item));
        }
    }

    public TreeMap<AccessRight, Boolean> getAccessRights() {
        return this.accessRights;
    }

    public boolean setAccessRights(AccessRight accessRight, boolean selected) {
        if (this.accessRights.containsKey((Object)accessRight)) {
            this.accessRights.put(accessRight, selected);
            return true;
        }
        return false;
    }

    public boolean setAccessRights(String accessRight, boolean selected) {
        return this.setAccessRights(AccessRight.valueOf(accessRight), selected);
    }

    public void setAccessRights(TreeMap<AccessRight, Boolean> accessRights) {
        for (AccessRight item : this.accessRights.keySet()) {
            this.accessRights.put(item, accessRights.get((Object)item));
        }
    }

    public void restrictAccessRights(CHAT mask) {
        CHAT.removeRights(this.readAccess, mask.readAccess);
        CHAT.removeRights(this.writeAccess, mask.writeAccess);
        CHAT.removeRights(this.specialFunctions, mask.specialFunctions);
        CHAT.removeRights(this.accessRights, mask.accessRights);
    }

    private static <T> void removeRights(TreeMap<T, Boolean> orig, TreeMap<T, Boolean> mask) {
        for (Map.Entry<T, Boolean> entry : mask.entrySet()) {
            if (entry.getValue().booleanValue()) continue;
            orig.put(entry.getKey(), false);
        }
    }

    public byte[] toByteArray() throws TLVException {
        byte[] data = new byte[5];
        switch (this.role) {
            case CVCA: {
                data[0] = (byte)(data[0] | 0xC0);
                break;
            }
            case DV_OFFICIAL: {
                data[0] = (byte)(data[0] | 0x80);
                break;
            }
            case DV_NON_OFFICIAL: {
                data[0] = (byte)(data[0] | 0x40);
                break;
            }
        }
        Iterator<DataGroup> it1 = this.writeAccess.keySet().iterator();
        for (int i = 2; i < 6; ++i) {
            DataGroup item = it1.next();
            if (!this.writeAccess.get((Object)item).booleanValue()) continue;
            ByteUtils.setBit(i, data);
        }
        Iterator<DataGroup> it2 = this.readAccess.keySet().iterator();
        for (int i = 31; i > 11; --i) {
            DataGroup item = it2.next();
            if (!this.readAccess.get((Object)item).booleanValue()) continue;
            ByteUtils.setBit(i, data);
        }
        Iterator<SpecialFunction> it3 = this.specialFunctions.keySet().iterator();
        for (int i = 32; i < 40; ++i) {
            SpecialFunction item = it3.next();
            if (!this.specialFunctions.get((Object)item).booleanValue()) continue;
            ByteUtils.setBit(i, data);
        }
        Iterator<AccessRight> it4 = this.accessRights.keySet().iterator();
        for (int i = 6; i < 7; ++i) {
            AccessRight item = it4.next();
            if (!this.accessRights.get((Object)item).booleanValue()) continue;
            ByteUtils.setBit(i, data);
        }
        TLV discretionaryDataObject = new TLV();
        discretionaryDataObject.setTagNumWithClass((byte)83);
        discretionaryDataObject.setValue(data);
        TLV oidObject = new TLV();
        oidObject.setTagNumWithClass((byte)6);
        oidObject.setValue(ObjectIdentifierUtils.getValue(this.oid));
        oidObject.addToEnd(discretionaryDataObject);
        TLV chatObject = new TLV();
        chatObject.setTagNum((byte)76);
        chatObject.setTagClass(TagClass.APPLICATION);
        chatObject.setChild(oidObject);
        return chatObject.toBER(true);
    }

    public boolean compareTo(CHAT chat) {
        try {
            return ByteUtils.compare(this.toByteArray(), chat.toByteArray());
        }
        catch (Exception e) {
            return false;
        }
    }

    public String toHexString() {
        try {
            return ByteUtils.toHexString(this.toByteArray(), true);
        }
        catch (TLVException ex) {
            _logger.error(ex.getMessage(), ex);
            return null;
        }
    }

    public String toString() {
        try {
            return ByteUtils.toHexString(this.toByteArray());
        }
        catch (TLVException ex) {
            _logger.error(ex.getMessage(), ex);
            return null;
        }
    }

    public static enum AccessRight {
        DG03,
        DG04,
        GENERATE_SIGNATURE,
        GENERATE_QUALIFIED_SIGNATURE;

    }

    public static enum DataGroup {
        DG01,
        DG02,
        DG03,
        DG04,
        DG05,
        DG06,
        DG07,
        DG08,
        DG09,
        DG10,
        DG11,
        DG12,
        DG13,
        DG14,
        DG15,
        DG16,
        DG17,
        DG18,
        DG19,
        DG20,
        DG21;

    }

    public static enum SpecialFunction {
        INSTALL_QUALIFIED_CERTIFICATE,
        INSTALL_CERTIFICATE,
        PIN_MANAGEMENT,
        CAN_ALLOWED,
        PRIVILEGED_TERMINAL,
        RESTRICTED_IDENTIFICATION,
        COMMUNITY_ID_VERIFICATION,
        AGE_VERIFICATION;

    }

    public static enum Role {
        CVCA,
        DV_OFFICIAL,
        DV_NON_OFFICIAL,
        AUTHENTICATION_TERMINAL,
        INSPECTION_TERMINAL,
        SIGNATURE_TERMINAL;

    }
}

