/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.io;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import org.openecard.common.OpenecardProperties;
import org.openecard.common.io.HttpConnectProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxySettings {
    private static final Logger logger = LoggerFactory.getLogger(ProxySettings.class);
    private static ProxySettings defaultInstance;
    private static Proxy systemProxy;
    private final Proxy proxy;

    public static synchronized void load() {
        Proxy p = null;
        String scheme = OpenecardProperties.getProperty("proxy.scheme");
        scheme = scheme != null ? scheme.toUpperCase() : "";
        String validate = OpenecardProperties.getProperty("proxy.validate_tls");
        String host = OpenecardProperties.getProperty("proxy.host");
        String port = OpenecardProperties.getProperty("proxy.port");
        String user = OpenecardProperties.getProperty("proxy.user");
        String pass = OpenecardProperties.getProperty("proxy.pass");
        if ("SOCKS".equals(scheme)) {
            try {
                if (host != null && port != null) {
                    p = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(host, Integer.parseInt(port)));
                }
            }
            catch (NumberFormatException ex) {}
        } else if ("HTTP".equals(scheme) || "HTTPS".equals(scheme)) {
            try {
                boolean valid = true;
                if (validate != null) {
                    valid = Boolean.parseBoolean(validate);
                }
                if (host != null && port != null) {
                    p = new HttpConnectProxy(scheme, valid, host, Integer.parseInt(port), user, pass);
                }
            }
            catch (NumberFormatException ex) {}
        } else if (!scheme.isEmpty()) {
            logger.warn("Unsupported proxy scheme {} used.", (Object)scheme);
        }
        systemProxy = p;
        defaultInstance = new ProxySettings();
    }

    public ProxySettings() {
        this.proxy = null;
    }

    private ProxySettings(Proxy proxy) {
        this.proxy = proxy;
    }

    public static ProxySettings getDefault() {
        return defaultInstance;
    }

    private Proxy getProxy(String hostname, int port) throws URISyntaxException {
        Proxy p;
        if (this.proxy == null) {
            if (systemProxy != null) {
                p = systemProxy;
            } else {
                ProxySelector selector = ProxySelector.getDefault();
                p = selector.select(new URI("socket://" + hostname + ":" + port)).get(0);
            }
        } else {
            p = this.proxy;
        }
        logger.debug("Selecting proxy: {}", (Object)p);
        return p;
    }

    public Socket getSocket(String hostname, int port) throws IOException, URISyntaxException {
        Socket sock;
        Proxy p = this.getProxy(hostname, port);
        if (p instanceof HttpConnectProxy) {
            HttpConnectProxy hp = (HttpConnectProxy)p;
            sock = hp.getSocket(hostname, port);
        } else {
            sock = new Socket(this.getProxy(hostname, port));
            InetSocketAddress addr = new InetSocketAddress(hostname, port);
            sock.setKeepAlive(true);
            sock.setSoTimeout(300000);
            sock.connect(addr, 60000);
        }
        return sock;
    }

    static {
        ProxySettings.load();
    }
}

