/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Properties;
import org.openecard.common.GenericFactoryException;

public class GenericFactory<T> {
    private final Constructor<T> constructor;

    public GenericFactory(Properties properties, String key) throws GenericFactoryException {
        String className = properties.getProperty(key);
        if (className == null) {
            throw new GenericFactoryException("No factory class defined for the specified key '" + key + "'.");
        }
        try {
            this.constructor = this.loadClass(className);
        }
        catch (ClassNotFoundException ex) {
            throw new GenericFactoryException(ex);
        }
        catch (NoSuchMethodException ex) {
            throw new GenericFactoryException(ex);
        }
    }

    public T getInstance() throws GenericFactoryException {
        try {
            T o = this.constructor.newInstance(new Object[0]);
            return o;
        }
        catch (InstantiationException ex) {
            throw new GenericFactoryException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new GenericFactoryException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw new GenericFactoryException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new GenericFactoryException(ex);
        }
    }

    private Constructor<T> loadClass(String className) throws ClassNotFoundException, GenericFactoryException, NoSuchMethodException {
        ClassLoader cl = this.getClass().getClassLoader();
        Class<?> c = cl.loadClass(className);
        Constructor<?> m = c.getConstructor(new Class[0]);
        if (Modifier.isPublic(m.getModifiers())) {
            return m;
        }
        throw new GenericFactoryException("Constructor of class " + className + " is not publicly available.");
    }
}

