/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.apache.http.impl;

import java.io.IOException;
import java.net.Socket;
import org.openecard.apache.http.annotation.NotThreadSafe;
import org.openecard.apache.http.impl.SocketHttpClientConnection;
import org.openecard.apache.http.params.HttpConnectionParams;
import org.openecard.apache.http.params.HttpParams;

@NotThreadSafe
public class DefaultHttpClientConnection
extends SocketHttpClientConnection {
    public void bind(Socket socket, HttpParams params) throws IOException {
        if (socket == null) {
            throw new IllegalArgumentException("Socket may not be null");
        }
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.assertNotOpen();
        socket.setTcpNoDelay(HttpConnectionParams.getTcpNoDelay(params));
        socket.setSoTimeout(HttpConnectionParams.getSoTimeout(params));
        socket.setKeepAlive(HttpConnectionParams.getSoKeepalive(params));
        int linger = HttpConnectionParams.getLinger(params);
        if (linger >= 0) {
            socket.setSoLinger(linger > 0, linger);
        }
        super.bind(socket, params);
    }
}

