/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jci.listeners;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.jci.monitor.FilesystemAlterationListener;
import org.apache.commons.jci.monitor.FilesystemAlterationObserver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractFilesystemAlterationListener
implements FilesystemAlterationListener {
    private final Log log = LogFactory.getLog(AbstractFilesystemAlterationListener.class);
    private final Collection createdFiles = new ArrayList();
    private final Collection changedFiles = new ArrayList();
    private final Collection deletedFiles = new ArrayList();
    private final Collection createdDirectories = new ArrayList();
    private final Collection changedDirectories = new ArrayList();
    private final Collection deletedDirectories = new ArrayList();
    private final Signal eventSignal = new Signal();
    private final Signal checkSignal = new Signal();
    protected FilesystemAlterationObserver observer;

    public void onDirectoryCreate(File pDir) {
        this.createdDirectories.add(pDir);
    }

    public void onDirectoryChange(File pDir) {
        this.changedDirectories.add(pDir);
    }

    public void onDirectoryDelete(File pDir) {
        this.deletedDirectories.add(pDir);
    }

    public void onFileCreate(File pFile) {
        this.createdFiles.add(pFile);
    }

    public void onFileChange(File pFile) {
        this.changedFiles.add(pFile);
    }

    public void onFileDelete(File pFile) {
        this.deletedFiles.add(pFile);
    }

    public Collection getChangedDirectories() {
        return this.changedDirectories;
    }

    public Collection getChangedFiles() {
        return this.changedFiles;
    }

    public Collection getCreatedDirectories() {
        return this.createdDirectories;
    }

    public Collection getCreatedFiles() {
        return this.createdFiles;
    }

    public Collection getDeletedDirectories() {
        return this.deletedDirectories;
    }

    public Collection getDeletedFiles() {
        return this.deletedFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void signals() {
        Signal signal;
        if (this.createdFiles.size() > 0 || this.createdDirectories.size() > 0 || this.changedFiles.size() > 0 || this.changedDirectories.size() > 0 || this.deletedFiles.size() > 0 || this.deletedDirectories.size() > 0) {
            this.log.debug("event signal");
            signal = this.eventSignal;
            synchronized (signal) {
                this.eventSignal.triggered = true;
                this.eventSignal.notifyAll();
            }
        }
        this.log.debug("check signal");
        signal = this.checkSignal;
        synchronized (signal) {
            this.checkSignal.triggered = true;
            this.checkSignal.notifyAll();
        }
    }

    public void onStart(FilesystemAlterationObserver pObserver) {
        this.observer = pObserver;
        this.createdFiles.clear();
        this.changedFiles.clear();
        this.deletedFiles.clear();
        this.createdDirectories.clear();
        this.changedDirectories.clear();
        this.deletedDirectories.clear();
    }

    public void onStop(FilesystemAlterationObserver pObserver) {
        this.signals();
        this.observer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForEvent() throws Exception {
        Signal signal = this.eventSignal;
        synchronized (signal) {
            this.eventSignal.triggered = false;
        }
        this.log.debug("waiting for change");
        if (!this.waitForSignal(this.eventSignal, 10)) {
            throw new Exception("timeout");
        }
    }

    public void waitForFirstCheck() throws Exception {
        this.log.debug("waiting for first check");
        if (!this.waitForSignal(this.checkSignal, 10)) {
            throw new Exception("timeout");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForCheck() throws Exception {
        Signal signal = this.checkSignal;
        synchronized (signal) {
            this.checkSignal.triggered = false;
        }
        this.log.debug("waiting for check");
        if (!this.waitForSignal(this.checkSignal, 10)) {
            throw new Exception("timeout");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForSignal(Signal pSignal, int pSecondsTimeout) {
        int i = 0;
        while (true) {
            Signal signal = pSignal;
            synchronized (signal) {
                if (pSignal.triggered) {
                    pSignal.triggered = false;
                    break;
                }
                try {
                    pSignal.wait(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (++i > pSecondsTimeout) {
                    this.log.error("timeout after " + pSecondsTimeout + "s");
                    return false;
                }
            }
        }
        return true;
    }

    private static final class Signal {
        public boolean triggered;

        private Signal() {
        }
    }
}

