/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.ws.soap;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.openecard.ws.soap.SOAPException;
import org.openecard.ws.soap.SOAPMessage;
import org.w3c.dom.Document;

public class MessageFactory {
    private final String protocol;
    private final DocumentBuilder domBuilder;

    private MessageFactory(String protocol, DocumentBuilder domBuilder) {
        this.protocol = protocol;
        this.domBuilder = domBuilder;
    }

    public static MessageFactory newInstance() throws SOAPException {
        return MessageFactory.newInstance("SOAP 1.1 Protocol");
    }

    public static MessageFactory newInstance(DocumentBuilder domBuilder) throws SOAPException {
        return MessageFactory.newInstance("SOAP 1.1 Protocol", domBuilder);
    }

    public static MessageFactory newInstance(String protocol) throws SOAPException {
        try {
            DocumentBuilderFactory tmpW3Factory = DocumentBuilderFactory.newInstance();
            tmpW3Factory.setNamespaceAware(true);
            tmpW3Factory.setIgnoringComments(true);
            DocumentBuilder tmpW3Builder = tmpW3Factory.newDocumentBuilder();
            return MessageFactory.newInstance(protocol, tmpW3Builder);
        }
        catch (ParserConfigurationException ex) {
            throw new SOAPException(ex);
        }
    }

    public static MessageFactory newInstance(String protocol, DocumentBuilder domBuilder) throws SOAPException {
        return new MessageFactory(protocol, domBuilder);
    }

    public SOAPMessage createMessage() throws SOAPException {
        SOAPMessage msg = new SOAPMessage(this.domBuilder, MessageFactory.getNamespace(this.protocol));
        return msg;
    }

    public SOAPMessage createMessage(Document doc) throws SOAPException {
        SOAPMessage msg = new SOAPMessage(doc);
        return msg;
    }

    protected static String getNamespace(String protocol) throws SOAPException {
        if (protocol.equals("SOAP 1.1 Protocol")) {
            return "http://schemas.xmlsoap.org/soap/envelope/";
        }
        if (protocol.equals("SOAP 1.2 Protocol")) {
            return "http://www.w3.org/2003/05/soap-envelope";
        }
        throw new SOAPException("Unsupported SOAP protocol.");
    }

    protected static String verifyNamespace(String namespace) throws SOAPException {
        if (namespace.equals("http://schemas.xmlsoap.org/soap/envelope/")) {
            return namespace;
        }
        if (namespace.equals("http://www.w3.org/2003/05/soap-envelope")) {
            return namespace;
        }
        throw new SOAPException("Unsupported SOAP protocol.");
    }
}

