/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.scio.osx;

import javax.smartcardio.Card;
import javax.smartcardio.CardException;
import javax.smartcardio.CardNotPresentException;
import javax.smartcardio.CardPermission;
import javax.smartcardio.CardTerminal;
import org.openecard.scio.osx.CardImpl;
import org.openecard.scio.osx.PCSC;
import org.openecard.scio.osx.PCSCException;

final class TerminalImpl
extends CardTerminal {
    final long contextId;
    final String name;
    private CardImpl card;

    TerminalImpl(long contextId, String name) {
        this.contextId = contextId;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public synchronized Card connect(String protocol) throws CardException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new CardPermission(this.name, "connect"));
        }
        if (this.card != null) {
            if (this.card.isValid()) {
                String cardProto = this.card.getProtocol();
                if (protocol.equals("*") || protocol.equalsIgnoreCase(cardProto)) {
                    return this.card;
                }
                throw new CardException("Cannot connect using " + protocol + ", connection already established using " + cardProto);
            }
            this.card = null;
        }
        try {
            this.card = new CardImpl(this, protocol);
            return this.card;
        }
        catch (PCSCException e) {
            if (e.code == -2146434967) {
                throw new CardNotPresentException("No card present", e);
            }
            throw new CardException("connect() failed", e);
        }
    }

    @Override
    public boolean isCardPresent() throws CardException {
        try {
            int[] status = PCSC.SCardGetStatusChange(this.contextId, 0L, new int[]{0}, new String[]{this.name});
            return (status[0] & 0x20) != 0;
        }
        catch (PCSCException e) {
            throw new CardException("isCardPresent() failed", e);
        }
    }

    private boolean waitForCard(boolean wantPresent, long timeout) throws CardException {
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout must not be negative");
        }
        if (timeout == 0L) {
            timeout = -1L;
        }
        int[] status = new int[]{0};
        String[] readers = new String[]{this.name};
        try {
            boolean present;
            status = PCSC.SCardGetStatusChange(this.contextId, 0L, status, readers);
            boolean bl = present = (status[0] & 0x20) != 0;
            if (wantPresent == present) {
                return true;
            }
            long end = System.currentTimeMillis() + timeout;
            while (wantPresent != present && timeout != 0L) {
                if (timeout != -1L) {
                    timeout = Math.max(end - System.currentTimeMillis(), 0L);
                }
                present = ((status = PCSC.SCardGetStatusChange(this.contextId, timeout, status, readers))[0] & 0x20) != 0;
            }
            return wantPresent == present;
        }
        catch (PCSCException e) {
            if (e.code == -2146435062) {
                return false;
            }
            throw new CardException("waitForCard() failed", e);
        }
    }

    @Override
    public boolean waitForCardPresent(long timeout) throws CardException {
        return this.waitForCard(true, timeout);
    }

    @Override
    public boolean waitForCardAbsent(long timeout) throws CardException {
        return this.waitForCard(false, timeout);
    }

    public String toString() {
        return "PC/SC terminal " + this.name;
    }
}

