/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.control.binding.http;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import org.openecard.apache.http.impl.DefaultConnectionReuseStrategy;
import org.openecard.apache.http.impl.DefaultHttpResponseFactory;
import org.openecard.apache.http.impl.DefaultHttpServerConnection;
import org.openecard.apache.http.params.BasicHttpParams;
import org.openecard.apache.http.protocol.BasicHttpContext;
import org.openecard.apache.http.protocol.BasicHttpProcessor;
import org.openecard.apache.http.protocol.HttpRequestHandler;
import org.openecard.apache.http.protocol.HttpRequestHandlerRegistry;
import org.openecard.apache.http.protocol.HttpService;
import org.openecard.apache.http.protocol.ImmutableHttpProcessor;
import org.openecard.control.handler.ControlHandler;
import org.openecard.control.handler.ControlHandlers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPService
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(HTTPService.class);
    private static final int backlog = 10;
    private final Thread thread = new Thread((Runnable)this, "Open-eCard Localhost-Binding");
    private final ServerSocket server;
    private final HttpService service;

    public HTTPService(int port, ControlHandlers handlers, BasicHttpProcessor interceptors) throws Exception {
        this.server = new ServerSocket(port, 10, InetAddress.getByName("127.0.0.1"));
        logger.debug("Starting HTTPBinding on port {}", (Object)this.server.getLocalPort());
        DefaultConnectionReuseStrategy connectionReuseStrategy = new DefaultConnectionReuseStrategy();
        DefaultHttpResponseFactory responseFactory = new DefaultHttpResponseFactory();
        ImmutableHttpProcessor httpProcessor = new ImmutableHttpProcessor(interceptors, interceptors);
        HttpRequestHandlerRegistry handlerRegistry = new HttpRequestHandlerRegistry();
        for (ControlHandler handler : handlers.getControlHandlers()) {
            if (handler instanceof HttpRequestHandler) {
                logger.debug("Add handler [{}] for ID [{}]", new Object[]{handler.getClass().getCanonicalName(), handler.getID()});
                handlerRegistry.register(handler.getID(), (HttpRequestHandler)((Object)handler));
                continue;
            }
            logger.error("Handler [{}] is not supported by the HTTPBinding");
        }
        BasicHttpParams params = new BasicHttpParams();
        this.service = new HttpService(httpProcessor, connectionReuseStrategy, responseFactory, handlerRegistry, params);
    }

    public void start() {
        this.thread.start();
    }

    public void interrupt() {
        try {
            this.thread.interrupt();
            this.server.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        while (!Thread.interrupted()) {
            try {
                final DefaultHttpServerConnection connection = new DefaultHttpServerConnection();
                connection.bind(this.server.accept(), new BasicHttpParams());
                new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            if (connection.isOpen()) {
                                HTTPService.this.service.handleRequest(connection, new BasicHttpContext());
                            }
                        }
                        catch (Exception e) {
                            logger.error(e.getMessage(), e);
                        }
                        finally {
                            try {
                                connection.shutdown();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }.start();
            }
            catch (Exception e) {
                logger.error(e.getMessage(), e);
            }
        }
    }

    public int getPort() {
        return this.server.getLocalPort();
    }
}

