/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.event;

import iso.std.iso_iec._24727.tech.schema.IFDStatusType;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.openecard.common.WSHelper;
import org.openecard.common.util.IFDStatusDiff;
import org.openecard.event.EventManager;
import org.openecard.event.WaitFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventRunner
implements Callable<Void> {
    private static final Logger _logger = LoggerFactory.getLogger(EventRunner.class);
    private final EventManager evtManager;
    private List<IFDStatusType> oldStati;
    private Future wait;

    public EventRunner(EventManager evtManager) {
        this.evtManager = evtManager;
        this.oldStati = new ArrayList<IFDStatusType>();
    }

    @Override
    public Void call() throws Exception {
        try {
            while (true) {
                this.wait = this.evtManager.threadPool.submit(new WaitFuture(this.evtManager));
                try {
                    List<IFDStatusType> newStati = this.evtManager.ifdStatus();
                    IFDStatusDiff diff = new IFDStatusDiff(this.oldStati);
                    diff.diff(newStati, true);
                    if (diff.hasChanges()) {
                        this.evtManager.sendEvents(this.oldStati, diff.result());
                    }
                    this.oldStati = newStati;
                }
                catch (WSHelper.WSException ex) {
                    _logger.warn("GetStatus returned with error.", ex);
                }
                this.wait.get();
            }
        }
        catch (Throwable throwable) {
            if (this.wait != null) {
                this.wait.cancel(true);
            }
            throw throwable;
        }
    }
}

