/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.common.asn1.eac;

import org.openecard.bouncycastle.asn1.ASN1Integer;
import org.openecard.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.openecard.bouncycastle.asn1.ASN1Sequence;
import org.openecard.crypto.common.asn1.eac.AlgorithmIdentifier;

public final class CADomainParameterInfo {
    private String protocol;
    private AlgorithmIdentifier domainParameter;
    private int keyID;
    private static final String[] protocols = new String[]{"0.4.0.127.0.7.2.2.3.1", "0.4.0.127.0.7.2.2.3.2"};

    public CADomainParameterInfo(ASN1Sequence seq) {
        if (seq.size() == 2) {
            this.protocol = ASN1ObjectIdentifier.getInstance(seq.getObjectAt(0)).toString();
            this.domainParameter = AlgorithmIdentifier.getInstance(seq.getObjectAt(1));
        } else if (seq.size() == 3) {
            this.protocol = ASN1ObjectIdentifier.getInstance(seq.getObjectAt(0)).toString();
            this.domainParameter = AlgorithmIdentifier.getInstance(seq.getObjectAt(1));
            this.keyID = ASN1Integer.getInstance(seq.getObjectAt(2)).getValue().intValue();
        } else {
            throw new IllegalArgumentException("Sequence wrong size for CADomainParameterInfo");
        }
    }

    public String getProtocol() {
        return this.protocol;
    }

    public AlgorithmIdentifier getDomainParameter() {
        return this.domainParameter;
    }

    public int getKeyID() {
        return this.keyID;
    }

    public static boolean isObjectIdentifier(String oid) {
        for (int i = 0; i < protocols.length; ++i) {
            if (!protocols[i].equals(oid)) continue;
            return true;
        }
        return false;
    }
}

