/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.control.module.tctoken;

import java.io.IOException;
import java.net.URL;
import org.openecard.common.util.Pair;
import org.openecard.control.module.tctoken.TCTokenRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCTokenHacks {
    private static final Logger logger = LoggerFactory.getLogger(TCTokenHacks.class);

    public static String fixPathSecurityParaneters(String input) {
        if (!input.contains("PathSecurity-Parameters")) {
            input = input.replace("PathSecurity-Parameter", "PathSecurity-Parameters");
        }
        if (input.contains("&lt;PSK&gt;")) {
            input = input.replace("&lt;PSK&gt;", "<PSK>");
        }
        if (input.contains("&lt;/PSK&gt;")) {
            input = input.replace("&lt;/PSK&gt;", "</PSK>");
        }
        return input;
    }

    public static String fixObjectTag(String input) {
        int x = input.indexOf("<object");
        int y = input.indexOf("object", x + 7);
        if (x == -1 || y == -1) {
            return input;
        }
        String data = input.substring(x, y);
        StringBuilder out = new StringBuilder(2048);
        out.append("<TCTokenType>");
        try {
            while (true) {
                Pair<String, String> result = TCTokenHacks.convertParameter(data);
                out.append((String)result.p1);
                data = (String)result.p2;
            }
        }
        catch (Exception ignore) {
            out.append("</TCTokenType>");
            return out.toString();
        }
    }

    private static Pair<String, String> convertParameter(String data) throws IOException {
        String input = data;
        StringBuilder out = new StringBuilder(2048);
        int x = input.indexOf("<param name=");
        if (x == -1) {
            throw new IOException();
        }
        String element = input.substring(x += 13, input.indexOf("\"", x));
        int y = input.indexOf("value=", x) + 7;
        String value = input.substring(y, input.indexOf("\"", y));
        out.append("<").append(element).append(">");
        out.append(value);
        out.append("</").append(element).append(">");
        data = input.substring(y + value.length(), input.length());
        return new Pair<String, String>(out.toString(), data);
    }

    public static boolean isPerformTR03112Checks(TCTokenRequest tcTokenRequest) {
        String tokenUrlStr;
        boolean activationChecks = true;
        String refreshAddress = tcTokenRequest.getTCToken().getRefreshAddress().toString();
        URL tokenUrl = tcTokenRequest.getTCTokenURL();
        if (!tcTokenRequest.getCardType().equals("http://bsi.bund.de/cif/npa.xml")) {
            activationChecks = false;
        } else if (refreshAddress.startsWith("https://eservice.openecard.org")) {
            activationChecks = false;
        } else if (tokenUrl != null && (tokenUrlStr = tokenUrl.toString()).startsWith("https://mtg.as.skidentity.de")) {
            activationChecks = false;
        }
        return activationChecks;
    }
}

