/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.crypto.tls;

import org.openecard.bouncycastle.crypto.CipherParameters;
import org.openecard.bouncycastle.crypto.CryptoException;
import org.openecard.bouncycastle.crypto.DSA;
import org.openecard.bouncycastle.crypto.Digest;
import org.openecard.bouncycastle.crypto.Signer;
import org.openecard.bouncycastle.crypto.digests.NullDigest;
import org.openecard.bouncycastle.crypto.digests.SHA1Digest;
import org.openecard.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.openecard.bouncycastle.crypto.params.ParametersWithRandom;
import org.openecard.bouncycastle.crypto.signers.DSADigestSigner;
import org.openecard.bouncycastle.crypto.tls.AbstractTlsSigner;

public abstract class TlsDSASigner
extends AbstractTlsSigner {
    @Override
    public byte[] generateRawSignature(AsymmetricKeyParameter privateKey, byte[] md5AndSha1) throws CryptoException {
        Signer signer = this.makeSigner(new NullDigest(), true, new ParametersWithRandom(privateKey, this.context.getSecureRandom()));
        signer.update(md5AndSha1, 16, 20);
        return signer.generateSignature();
    }

    @Override
    public boolean verifyRawSignature(byte[] sigBytes, AsymmetricKeyParameter publicKey, byte[] md5AndSha1) throws CryptoException {
        Signer signer = this.makeSigner(new NullDigest(), false, publicKey);
        signer.update(md5AndSha1, 16, 20);
        return signer.verifySignature(sigBytes);
    }

    @Override
    public Signer createSigner(AsymmetricKeyParameter privateKey) {
        return this.makeSigner(new SHA1Digest(), true, new ParametersWithRandom(privateKey, this.context.getSecureRandom()));
    }

    @Override
    public Signer createVerifyer(AsymmetricKeyParameter publicKey) {
        return this.makeSigner(new SHA1Digest(), false, publicKey);
    }

    protected Signer makeSigner(Digest d, boolean forSigning, CipherParameters cp) {
        DSADigestSigner s = new DSADigestSigner(this.createDSAImpl(), d);
        s.init(forSigning, cp);
        return s;
    }

    protected abstract DSA createDSAImpl();
}

