/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.crypto.tls;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.openecard.bouncycastle.crypto.Digest;
import org.openecard.bouncycastle.crypto.tls.DeferredHash;
import org.openecard.bouncycastle.crypto.tls.ProtocolVersion;
import org.openecard.bouncycastle.crypto.tls.TlsCipher;
import org.openecard.bouncycastle.crypto.tls.TlsCompression;
import org.openecard.bouncycastle.crypto.tls.TlsContext;
import org.openecard.bouncycastle.crypto.tls.TlsFatalAlert;
import org.openecard.bouncycastle.crypto.tls.TlsHandshakeHash;
import org.openecard.bouncycastle.crypto.tls.TlsNullCipher;
import org.openecard.bouncycastle.crypto.tls.TlsNullCompression;
import org.openecard.bouncycastle.crypto.tls.TlsProtocol;
import org.openecard.bouncycastle.crypto.tls.TlsUtils;

class RecordStream {
    private static int PLAINTEXT_LIMIT = 16384;
    private static int COMPRESSED_LIMIT = PLAINTEXT_LIMIT + 1024;
    private static int CIPHERTEXT_LIMIT = COMPRESSED_LIMIT + 1024;
    private TlsProtocol handler;
    private InputStream input;
    private OutputStream output;
    private TlsCompression pendingCompression = null;
    private TlsCompression readCompression = null;
    private TlsCompression writeCompression = null;
    private TlsCipher pendingCipher = null;
    private TlsCipher readCipher = null;
    private TlsCipher writeCipher = null;
    private long readSeqNo = 0L;
    private long writeSeqNo = 0L;
    private ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private TlsContext context = null;
    private TlsHandshakeHash hash = null;
    private ProtocolVersion readVersion = null;
    private ProtocolVersion writeVersion = null;
    private boolean restrictReadVersion = true;

    RecordStream(TlsProtocol handler, InputStream input, OutputStream output) {
        this.handler = handler;
        this.input = input;
        this.output = output;
        this.writeCompression = this.readCompression = new TlsNullCompression();
        this.writeCipher = this.readCipher = new TlsNullCipher(this.context);
    }

    void init(TlsContext context) {
        this.context = context;
        this.hash = new DeferredHash();
        this.hash.init(context);
    }

    ProtocolVersion getReadVersion() {
        return this.readVersion;
    }

    void setReadVersion(ProtocolVersion readVersion) {
        this.readVersion = readVersion;
    }

    void setWriteVersion(ProtocolVersion writeVersion) {
        this.writeVersion = writeVersion;
    }

    void setRestrictReadVersion(boolean enabled) {
        this.restrictReadVersion = enabled;
    }

    void notifyHelloComplete() {
        this.hash = this.hash.commit();
    }

    void setPendingConnectionState(TlsCompression tlsCompression, TlsCipher tlsCipher) {
        this.pendingCompression = tlsCompression;
        this.pendingCipher = tlsCipher;
    }

    void sentWriteCipherSpec() throws IOException {
        if (this.pendingCompression == null || this.pendingCipher == null) {
            throw new TlsFatalAlert(40);
        }
        this.writeCompression = this.pendingCompression;
        this.writeCipher = this.pendingCipher;
        this.writeSeqNo = 0L;
    }

    void receivedReadCipherSpec() throws IOException {
        if (this.pendingCompression == null || this.pendingCipher == null) {
            throw new TlsFatalAlert(40);
        }
        this.readCompression = this.pendingCompression;
        this.readCipher = this.pendingCipher;
        this.readSeqNo = 0L;
    }

    void finaliseHandshake() throws IOException {
        if (this.readCompression != this.pendingCompression || this.writeCompression != this.pendingCompression || this.readCipher != this.pendingCipher || this.writeCipher != this.pendingCipher) {
            throw new TlsFatalAlert(40);
        }
        this.pendingCompression = null;
        this.pendingCipher = null;
    }

    public void readRecord() throws IOException {
        short type = TlsUtils.readUint8(this.input);
        RecordStream.checkType(type, (short)10);
        if (!this.restrictReadVersion) {
            int version = TlsUtils.readVersionRaw(this.input);
            if ((version & 0xFFFFFF00) != 768) {
                throw new TlsFatalAlert(47);
            }
        } else {
            ProtocolVersion version = TlsUtils.readVersion(this.input);
            if (this.readVersion == null) {
                this.readVersion = version;
            } else if (!version.equals(this.readVersion)) {
                throw new TlsFatalAlert(47);
            }
        }
        int length = TlsUtils.readUint16(this.input);
        byte[] plaintext = this.decodeAndVerify(type, this.input, length);
        this.handler.processRecord(type, plaintext, 0, plaintext.length);
    }

    protected byte[] decodeAndVerify(short type, InputStream input, int len) throws IOException {
        RecordStream.checkLength(len, CIPHERTEXT_LIMIT, (short)22);
        byte[] buf = TlsUtils.readFully(len, input);
        byte[] decoded = this.readCipher.decodeCiphertext(this.readSeqNo++, type, buf, 0, buf.length);
        RecordStream.checkLength(decoded.length, COMPRESSED_LIMIT, (short)22);
        OutputStream cOut = this.readCompression.decompress(this.buffer);
        if (cOut != this.buffer) {
            cOut.write(decoded, 0, decoded.length);
            cOut.flush();
            decoded = this.getBufferContents();
        }
        RecordStream.checkLength(decoded.length, PLAINTEXT_LIMIT, (short)30);
        return decoded;
    }

    protected void writeRecord(short type, byte[] plaintext, int plaintextOffset, int plaintextLength) throws IOException {
        byte[] ciphertext;
        OutputStream cOut;
        RecordStream.checkType(type, (short)80);
        RecordStream.checkLength(plaintextLength, PLAINTEXT_LIMIT, (short)80);
        if (plaintextLength < 1 && type != 23) {
            throw new TlsFatalAlert(80);
        }
        if (type == 22) {
            this.updateHandshakeData(plaintext, plaintextOffset, plaintextLength);
        }
        if ((cOut = this.writeCompression.compress(this.buffer)) == this.buffer) {
            ciphertext = this.writeCipher.encodePlaintext(this.writeSeqNo++, type, plaintext, plaintextOffset, plaintextLength);
        } else {
            cOut.write(plaintext, plaintextOffset, plaintextLength);
            cOut.flush();
            byte[] compressed = this.getBufferContents();
            RecordStream.checkLength(compressed.length, plaintextLength + 1024, (short)80);
            ciphertext = this.writeCipher.encodePlaintext(this.writeSeqNo++, type, compressed, 0, compressed.length);
        }
        RecordStream.checkLength(ciphertext.length, CIPHERTEXT_LIMIT, (short)80);
        byte[] record = new byte[ciphertext.length + 5];
        TlsUtils.writeUint8(type, record, 0);
        TlsUtils.writeVersion(this.writeVersion, record, 1);
        TlsUtils.writeUint16(ciphertext.length, record, 3);
        System.arraycopy(ciphertext, 0, record, 5, ciphertext.length);
        this.output.write(record);
        this.output.flush();
    }

    void updateHandshakeData(byte[] message, int offset, int len) {
        this.hash.update(message, offset, len);
    }

    byte[] getCurrentHash(byte[] sender) {
        TlsHandshakeHash d = this.hash.fork();
        if (this.context.getServerVersion().isSSL() && sender != null) {
            d.update(sender, 0, sender.length);
        }
        return RecordStream.doFinal(d);
    }

    protected void close() throws IOException {
        IOException e = null;
        try {
            this.input.close();
        }
        catch (IOException ex) {
            e = ex;
        }
        try {
            this.output.close();
        }
        catch (IOException ex) {
            e = ex;
        }
        if (e != null) {
            throw e;
        }
    }

    protected void flush() throws IOException {
        this.output.flush();
    }

    private byte[] getBufferContents() {
        byte[] contents = this.buffer.toByteArray();
        this.buffer.reset();
        return contents;
    }

    private static byte[] doFinal(Digest d) {
        byte[] bs = new byte[d.getDigestSize()];
        d.doFinal(bs, 0);
        return bs;
    }

    private static void checkType(short type, short alertDescription) throws IOException {
        switch (type) {
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                break;
            }
            default: {
                throw new TlsFatalAlert(alertDescription);
            }
        }
    }

    private static void checkLength(int length, int limit, short alertDescription) throws IOException {
        if (length > limit) {
            throw new TlsFatalAlert(alertDescription);
        }
    }
}

