/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.crypto.agreement.kdf;

import java.io.IOException;
import org.openecard.bouncycastle.asn1.ASN1Encodable;
import org.openecard.bouncycastle.asn1.ASN1EncodableVector;
import org.openecard.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.openecard.bouncycastle.asn1.DERNull;
import org.openecard.bouncycastle.asn1.DEROctetString;
import org.openecard.bouncycastle.asn1.DERSequence;
import org.openecard.bouncycastle.asn1.DERTaggedObject;
import org.openecard.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.openecard.bouncycastle.crypto.DataLengthException;
import org.openecard.bouncycastle.crypto.DerivationFunction;
import org.openecard.bouncycastle.crypto.DerivationParameters;
import org.openecard.bouncycastle.crypto.Digest;
import org.openecard.bouncycastle.crypto.agreement.kdf.DHKDFParameters;
import org.openecard.bouncycastle.crypto.generators.KDF2BytesGenerator;
import org.openecard.bouncycastle.crypto.params.KDFParameters;
import org.openecard.bouncycastle.crypto.util.Pack;

public class ECDHKEKGenerator
implements DerivationFunction {
    private DerivationFunction kdf;
    private ASN1ObjectIdentifier algorithm;
    private int keySize;
    private byte[] z;

    public ECDHKEKGenerator(Digest digest) {
        this.kdf = new KDF2BytesGenerator(digest);
    }

    @Override
    public void init(DerivationParameters param) {
        DHKDFParameters params = (DHKDFParameters)param;
        this.algorithm = params.getAlgorithm();
        this.keySize = params.getKeySize();
        this.z = params.getZ();
    }

    @Override
    public Digest getDigest() {
        return this.kdf.getDigest();
    }

    @Override
    public int generateBytes(byte[] out, int outOff, int len) throws DataLengthException, IllegalArgumentException {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new AlgorithmIdentifier(this.algorithm, (ASN1Encodable)DERNull.INSTANCE));
        v.add(new DERTaggedObject(true, 2, new DEROctetString(Pack.intToBigEndian(this.keySize))));
        try {
            this.kdf.init(new KDFParameters(this.z, new DERSequence(v).getEncoded("DER")));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("unable to initialise kdf: " + e.getMessage());
        }
        return this.kdf.generateBytes(out, outOff, len);
    }
}

