/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.ifd.scio;

import iso.std.iso_iec._24727.tech.schema.ChannelHandleType;
import iso.std.iso_iec._24727.tech.schema.GetStatus;
import iso.std.iso_iec._24727.tech.schema.GetStatusResponse;
import iso.std.iso_iec._24727.tech.schema.IFDStatusType;
import iso.std.iso_iec._24727.tech.schema.SignalEvent;
import iso.std.iso_iec._24727.tech.schema.SignalEventResponse;
import iso.std.iso_iec._24727.tech.schema.SlotStatusType;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.openecard.common.util.IFDStatusDiff;
import org.openecard.ifd.scio.IFD;
import org.openecard.ifd.scio.IFDException;
import org.openecard.ifd.scio.IFDProperties;
import org.openecard.ifd.scio.wrapper.SCTerminal;
import org.openecard.ifd.scio.wrapper.SCWrapper;
import org.openecard.ws.IFDCallback;
import org.openecard.ws.marshal.WSClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventListener
implements Callable<List<IFDStatusType>> {
    private static final Logger logger = LoggerFactory.getLogger(EventListener.class);
    private static final long pollDelay;
    private static final long pauseDelay;
    private static long pauseTime;
    private final IFD ifd;
    private final SCWrapper scWrapper;
    private final byte[] ctxHandle;
    private final boolean withNew;
    private final ChannelHandleType callback;
    private final List<IFDStatusType> expectedStatuses;
    private final long timeout;
    private final long startTime;
    private Future<Void> termWatcher;

    public EventListener(IFD ifd, SCWrapper scWrapper, byte[] ctxHandle, long timeout, ChannelHandleType callback, List<IFDStatusType> expectedStatuses, boolean withNew) {
        this.ifd = ifd;
        this.scWrapper = scWrapper;
        this.ctxHandle = ctxHandle;
        this.timeout = timeout;
        this.callback = callback;
        this.expectedStatuses = expectedStatuses;
        this.withNew = withNew;
        this.startTime = System.currentTimeMillis();
    }

    public static synchronized void pause() {
        pauseTime = System.currentTimeMillis() + pauseDelay;
    }

    @Override
    public List<IFDStatusType> call() throws Exception {
        try {
            List<IFDStatusType> result = this.waitForEvent();
            if (this.isAsync()) {
                this.sendResult(result);
            }
            List<IFDStatusType> list = result;
            return list;
        }
        catch (TimeoutException ex) {
            logger.warn(ex.getMessage(), ex);
            throw new IFDException("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/common#timeoutError", "Wait timed out.");
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage(), ex);
            throw ex;
        }
        finally {
            if (this.isAsync()) {
                this.ifd.removeAsnycTerminal(this.callback.getSessionIdentifier());
            }
            if (this.termWatcher != null) {
                this.termWatcher.cancel(true);
            }
        }
    }

    private List<IFDStatusType> waitForEvent() throws IFDException, InterruptedException, ExecutionException, TimeoutException {
        this.termWatcher = this.ifd.runCallable(new TerminalWatcher());
        List<IFDStatusType> currentStatus = this.getCurrentStatus();
        IFDStatusDiff diff = new IFDStatusDiff(this.expectedStatuses);
        diff.diff(currentStatus, this.withNew);
        if (diff.hasChanges()) {
            this.termWatcher.cancel(true);
            return diff.result();
        }
        long elapsedTime = System.currentTimeMillis() - this.startTime;
        long actualTimeout = this.timeout - elapsedTime;
        actualTimeout = actualTimeout < 0L ? 1L : actualTimeout;
        this.termWatcher.get(actualTimeout, TimeUnit.MILLISECONDS);
        currentStatus = this.getCurrentStatus();
        diff = new IFDStatusDiff(this.expectedStatuses);
        diff.diff(currentStatus, this.withNew);
        return diff.result();
    }

    private List<IFDStatusType> getCurrentStatus() throws IFDException {
        GetStatus statusReq = new GetStatus();
        statusReq.setContextHandle(this.ctxHandle);
        GetStatusResponse status = this.ifd.getStatus(statusReq);
        if (status.getResult().getResultMajor().equals("http://www.bsi.bund.de/ecard/api/1.1/resultmajor#error")) {
            IFDException ex = new IFDException(status.getResult());
            logger.warn(ex.getMessage(), ex);
            throw ex;
        }
        return status.getIFDStatus();
    }

    private void sendResult(List<IFDStatusType> result) {
        try {
            IFDCallback endpoint = (IFDCallback)WSClassLoader.getClientService("IFDCallback", this.callback.getProtocolTerminationPoint());
            SignalEvent sevt = new SignalEvent();
            sevt.setContextHandle(this.ctxHandle);
            sevt.setSessionIdentifier(this.callback.getSessionIdentifier());
            sevt.getIFDEvent().addAll(result);
            SignalEventResponse sevtResp = endpoint.signalEvent(sevt);
            if (sevtResp.getResult().getResultMajor().equals("http://www.bsi.bund.de/ecard/api/1.1/resultmajor#error")) {
                logger.error("SignalEvent returned with an error.\n{}", (Object)sevtResp);
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), ex);
        }
    }

    public boolean isAsync() {
        return this.callback != null;
    }

    private boolean expectedContains(String ifdName) {
        Boolean b = this.expectedGet(ifdName) != null;
        return b;
    }

    private boolean expectedHasCard(String ifdName) {
        IFDStatusType s = this.expectedGet(ifdName);
        List<SlotStatusType> slots = s.getSlotStatus();
        boolean result = false;
        if (!slots.isEmpty()) {
            SlotStatusType slot = slots.get(0);
            result = slot.isCardAvailable();
        }
        return result;
    }

    private IFDStatusType expectedGet(String ifdName) {
        IFDStatusType result = null;
        for (IFDStatusType s : this.expectedStatuses) {
            if (!s.getIFDName().equals(ifdName)) continue;
            result = s;
            break;
        }
        return result;
    }

    static {
        pauseTime = 0L;
        String delayStr = IFDProperties.getProperty("org.openecard.ifd.wait.delay");
        long delay = 500L;
        if (delayStr != null) {
            try {
                delay = Long.parseLong(delayStr);
            }
            catch (NumberFormatException ex) {
                logger.warn("Property 'org.openecard.ifd.wait.delay' contains a malformed number.", ex);
            }
        }
        pollDelay = delay;
        String pauseStr = IFDProperties.getProperty("org.openecard.ifd.wait.pause");
        long pause = 2000L;
        if (delayStr != null) {
            try {
                pause = Long.parseLong(pauseStr);
            }
            catch (NumberFormatException ex) {
                logger.warn("Property 'org.openecard.ifd.wait.pause' contains a malformed number.", ex);
            }
        }
        pauseDelay = pause;
    }

    private class TerminalWatcher
    implements Callable<Void> {
        private TerminalWatcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public Void call() throws Exception {
            int pcscErrorCount = 0;
            boolean change = false;
            block10: while (!change) {
                List<SCTerminal> termList = EventListener.this.scWrapper.getTerminals(true);
                try {
                    LinkedList deleted = new LinkedList(EventListener.this.expectedStatuses);
                    for (SCTerminal t : termList) {
                        if (EventListener.this.expectedContains(t.getName())) {
                            if (t.isCardPresent() != EventListener.this.expectedHasCard(t.getName())) {
                                return null;
                            }
                            deleted.remove(EventListener.this.expectedGet(t.getName()));
                            continue;
                        }
                        if (!EventListener.this.withNew) continue;
                        return null;
                    }
                    if (!deleted.isEmpty()) {
                        return null;
                    }
                    while (true) {
                        Class<EventListener> clazz = EventListener.class;
                        // MONITORENTER : org.openecard.ifd.scio.EventListener.class
                        long currentPauseTime = pauseTime;
                        // MONITOREXIT : clazz
                        long now = System.currentTimeMillis();
                        if (now > currentPauseTime) {
                            change = EventListener.this.scWrapper.waitForChange(pollDelay);
                            continue block10;
                        }
                        Thread.sleep(currentPauseTime - now);
                    }
                }
                catch (IFDException ex) {
                    if (++pcscErrorCount == 500) {
                        throw ex;
                    }
                    Thread.sleep(1000L);
                }
                catch (IllegalStateException ex) {
                    Thread.sleep(pollDelay);
                }
            }
            return null;
            {
                catch (Exception ex) {
                    logger.error(ex.getMessage(), ex);
                    throw ex;
                }
            }
        }
    }
}

