/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.ifd.protocol.pace.crypto;

import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KDF {
    private static final Logger logger = LoggerFactory.getLogger(KDF.class);
    private MessageDigest md;
    private int keyLength;

    public KDF() throws GeneralSecurityException {
        try {
            this.md = MessageDigest.getInstance("SHA1");
            this.keyLength = 16;
        }
        catch (NoSuchAlgorithmException ex) {
            logger.error(ex.getMessage(), ex);
            throw new GeneralSecurityException(ex);
        }
    }

    public KDF(MessageDigest md, int keyLength) {
        this.md = md;
        this.keyLength = keyLength;
    }

    public byte[] derivePI(byte[] secret) {
        return this.derive(secret, (byte)3, null);
    }

    public byte[] deriveMAC(byte[] secret) {
        return this.derive(secret, (byte)2, null);
    }

    public byte[] deriveMAC(byte[] secret, byte[] nonce) {
        return this.derive(secret, (byte)2, nonce);
    }

    public byte[] deriveENC(byte[] secret) {
        return this.derive(secret, (byte)1, null);
    }

    public byte[] deriveENC(byte[] secret, byte[] nonce) {
        return this.derive(secret, (byte)1, nonce);
    }

    private byte[] derive(byte[] secret, byte counter, byte[] nonce) {
        byte[] c = new byte[]{0, 0, 0, counter};
        byte[] key = new byte[this.keyLength];
        this.md.reset();
        this.md.update(secret, 0, secret.length);
        if (nonce != null) {
            this.md.update(nonce, 0, nonce.length);
        }
        this.md.update(c, 0, c.length);
        byte[] hash = this.md.digest();
        System.arraycopy(hash, 0, key, 0, key.length);
        return key;
    }
}

