/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.common.asn1.eac.ef;

import org.openecard.bouncycastle.asn1.ASN1Sequence;
import org.openecard.bouncycastle.asn1.ASN1Set;
import org.openecard.crypto.common.asn1.eac.CADomainParameterInfo;
import org.openecard.crypto.common.asn1.eac.CAInfo;
import org.openecard.crypto.common.asn1.eac.CASecurityInfos;
import org.openecard.crypto.common.asn1.eac.CardInfoLocator;
import org.openecard.crypto.common.asn1.eac.PACEDomainParameterInfo;
import org.openecard.crypto.common.asn1.eac.PACEInfo;
import org.openecard.crypto.common.asn1.eac.PACESecurityInfos;
import org.openecard.crypto.common.asn1.eac.PrivilegedTerminalInfo;
import org.openecard.crypto.common.asn1.eac.SecurityInfos;
import org.openecard.crypto.common.asn1.eac.TAInfo;
import org.openecard.crypto.common.asn1.eac.TASecurityInfos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EFCardAccess {
    private static final Logger _logger = LoggerFactory.getLogger(EFCardAccess.class);
    private SecurityInfos sis;
    private PACESecurityInfos psi;
    private TASecurityInfos tsi;
    private CASecurityInfos csi;
    private CardInfoLocator cil;
    private PrivilegedTerminalInfo pti;

    public EFCardAccess(SecurityInfos sis) {
        this.sis = sis;
        this.decodeSecurityInfos();
    }

    public EFCardAccess(byte[] sis) {
        this.sis = SecurityInfos.getInstance(sis);
        this.decodeSecurityInfos();
    }

    private void decodeSecurityInfos() {
        ASN1Set securityinfos = this.sis.getSecurityInfos();
        int length = securityinfos.size();
        this.psi = new PACESecurityInfos();
        this.tsi = new TASecurityInfos();
        this.csi = new CASecurityInfos();
        for (int i = 0; i < length; ++i) {
            ASN1Sequence securityInfo = (ASN1Sequence)securityinfos.getObjectAt(i);
            String oid = securityInfo.getObjectAt(0).toString();
            if (PACEInfo.isPACEObjectIdentifer(oid)) {
                _logger.debug("Found PACEInfo object identifier");
                PACEInfo pi = new PACEInfo(securityInfo);
                this.psi.addPACEInfo(pi);
                continue;
            }
            if (PACEDomainParameterInfo.isPACEObjectIdentifer(oid)) {
                _logger.debug("Found PACEDomainParameterInfo object identifier");
                PACEDomainParameterInfo pdp = new PACEDomainParameterInfo(securityInfo);
                this.psi.addPACEDomainParameterInfo(pdp);
                continue;
            }
            if (CAInfo.isObjectIdentifier(oid)) {
                _logger.debug("Found ChipAuthenticationInfo object identifier");
                CAInfo ci = new CAInfo(securityInfo);
                this.csi.addCAInfo(ci);
                continue;
            }
            if (CADomainParameterInfo.isObjectIdentifier(oid)) {
                _logger.debug("Found ChipAuthenticationDomainParameterInfo object identifier");
                CADomainParameterInfo cdp = new CADomainParameterInfo(securityInfo);
                this.csi.addCADomainParameterInfo(cdp);
                continue;
            }
            if ("0.4.0.127.0.7.2.2.2".equals(oid)) {
                _logger.debug("Found TerminalAuthenticationInfo object identifier");
                TAInfo ta = new TAInfo(securityInfo);
                this.tsi.addTAInfo(ta);
                continue;
            }
            if ("0.4.0.127.0.7.2.2.6".equals(oid)) {
                _logger.debug("Found CardInfoLocator object identifier");
                this.cil = CardInfoLocator.getInstance(securityInfo);
                continue;
            }
            if ("0.4.0.127.0.7.2.2.8".equals(oid)) {
                _logger.debug("Found PrivilegedTerminalInfo object identifier");
                this.pti = PrivilegedTerminalInfo.getInstance(securityInfo);
                continue;
            }
            _logger.debug("Found unknown object identifier: {}", (Object)oid.toString());
        }
    }

    public PACESecurityInfos getPACESecurityInfos() {
        return this.psi;
    }

    public TASecurityInfos getTASecurityInfos() {
        return this.tsi;
    }

    public CASecurityInfos getCASecurityInfos() {
        return this.csi;
    }

    public CardInfoLocator getCardInfoLocator() {
        return this.cil;
    }

    public PrivilegedTerminalInfo getPrivilegedTerminalInfo() {
        return this.pti;
    }
}

