/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.bcpg;

import java.io.IOException;
import org.openecard.bouncycastle.bcpg.BCPGInputStream;
import org.openecard.bouncycastle.bcpg.BCPGOutputStream;
import org.openecard.bouncycastle.bcpg.ContainedPacket;
import org.openecard.bouncycastle.bcpg.PublicKeyAlgorithmTags;
import org.openecard.bouncycastle.util.Arrays;

public class ExperimentalPacket
extends ContainedPacket
implements PublicKeyAlgorithmTags {
    private int tag;
    private byte[] contents;

    ExperimentalPacket(int tag, BCPGInputStream in) throws IOException {
        this.tag = tag;
        this.contents = in.readAll();
    }

    public int getTag() {
        return this.tag;
    }

    public byte[] getContents() {
        return Arrays.clone(this.contents);
    }

    @Override
    public void encode(BCPGOutputStream out) throws IOException {
        out.writePacket(this.tag, this.contents, true);
    }
}

