/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.sal.protocol.eac.anytype;

import iso.std.iso_iec._24727.tech.schema.DIDAuthenticationDataType;
import javax.xml.parsers.ParserConfigurationException;
import org.openecard.common.anytype.AuthDataMap;
import org.openecard.sal.protocol.eac.anytype.PACEOutputType;

public class PACEInputType {
    public static final String PIN_ID = "PinID";
    public static final String CHAT = "CHAT";
    public static final String PIN = "PIN";
    public static final String CERTIFICATE_DESCRIPTION = "CertificateDescription";
    private final AuthDataMap authMap;
    private final String pin;
    private final byte pinID;
    private final byte[] chat;
    private final byte[] certDesc;

    public PACEInputType(DIDAuthenticationDataType baseType) throws ParserConfigurationException {
        this.authMap = new AuthDataMap(baseType);
        this.pinID = this.authMap.getContentAsBytes(PIN_ID)[0];
        this.chat = this.authMap.getContentAsBytes(CHAT);
        this.pin = this.authMap.getContentAsString(PIN);
        this.certDesc = this.authMap.getContentAsBytes(CERTIFICATE_DESCRIPTION);
    }

    public byte getPINID() {
        return this.pinID;
    }

    public byte[] getCHAT() {
        return this.chat;
    }

    public String getPIN() {
        return this.pin;
    }

    public byte[] getCertificateDescription() {
        return this.certDesc;
    }

    public PACEOutputType getOutputType() {
        return new PACEOutputType(this.authMap);
    }
}

