/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.sal;

import iso.std.iso_iec._24727.tech.schema.ACLList;
import iso.std.iso_iec._24727.tech.schema.ACLListResponse;
import iso.std.iso_iec._24727.tech.schema.ACLModify;
import iso.std.iso_iec._24727.tech.schema.ACLModifyResponse;
import iso.std.iso_iec._24727.tech.schema.AuthorizationServiceActionName;
import iso.std.iso_iec._24727.tech.schema.CardApplicationConnect;
import iso.std.iso_iec._24727.tech.schema.CardApplicationConnectResponse;
import iso.std.iso_iec._24727.tech.schema.CardApplicationCreate;
import iso.std.iso_iec._24727.tech.schema.CardApplicationCreateResponse;
import iso.std.iso_iec._24727.tech.schema.CardApplicationDelete;
import iso.std.iso_iec._24727.tech.schema.CardApplicationDeleteResponse;
import iso.std.iso_iec._24727.tech.schema.CardApplicationDisconnect;
import iso.std.iso_iec._24727.tech.schema.CardApplicationDisconnectResponse;
import iso.std.iso_iec._24727.tech.schema.CardApplicationEndSession;
import iso.std.iso_iec._24727.tech.schema.CardApplicationEndSessionResponse;
import iso.std.iso_iec._24727.tech.schema.CardApplicationList;
import iso.std.iso_iec._24727.tech.schema.CardApplicationListResponse;
import iso.std.iso_iec._24727.tech.schema.CardApplicationPath;
import iso.std.iso_iec._24727.tech.schema.CardApplicationPathResponse;
import iso.std.iso_iec._24727.tech.schema.CardApplicationPathType;
import iso.std.iso_iec._24727.tech.schema.CardApplicationServiceActionName;
import iso.std.iso_iec._24727.tech.schema.CardApplicationServiceCreate;
import iso.std.iso_iec._24727.tech.schema.CardApplicationServiceCreateResponse;
import iso.std.iso_iec._24727.tech.schema.CardApplicationServiceDelete;
import iso.std.iso_iec._24727.tech.schema.CardApplicationServiceDeleteResponse;
import iso.std.iso_iec._24727.tech.schema.CardApplicationServiceDescribe;
import iso.std.iso_iec._24727.tech.schema.CardApplicationServiceDescribeResponse;
import iso.std.iso_iec._24727.tech.schema.CardApplicationServiceList;
import iso.std.iso_iec._24727.tech.schema.CardApplicationServiceListResponse;
import iso.std.iso_iec._24727.tech.schema.CardApplicationServiceLoad;
import iso.std.iso_iec._24727.tech.schema.CardApplicationServiceLoadResponse;
import iso.std.iso_iec._24727.tech.schema.CardApplicationStartSession;
import iso.std.iso_iec._24727.tech.schema.CardApplicationStartSessionResponse;
import iso.std.iso_iec._24727.tech.schema.Connect;
import iso.std.iso_iec._24727.tech.schema.ConnectResponse;
import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import iso.std.iso_iec._24727.tech.schema.ConnectionServiceActionName;
import iso.std.iso_iec._24727.tech.schema.DIDAuthenticate;
import iso.std.iso_iec._24727.tech.schema.DIDAuthenticateResponse;
import iso.std.iso_iec._24727.tech.schema.DIDAuthenticationDataType;
import iso.std.iso_iec._24727.tech.schema.DIDCreate;
import iso.std.iso_iec._24727.tech.schema.DIDCreateResponse;
import iso.std.iso_iec._24727.tech.schema.DIDDelete;
import iso.std.iso_iec._24727.tech.schema.DIDDeleteResponse;
import iso.std.iso_iec._24727.tech.schema.DIDGet;
import iso.std.iso_iec._24727.tech.schema.DIDGetResponse;
import iso.std.iso_iec._24727.tech.schema.DIDInfoType;
import iso.std.iso_iec._24727.tech.schema.DIDList;
import iso.std.iso_iec._24727.tech.schema.DIDListResponse;
import iso.std.iso_iec._24727.tech.schema.DIDNameListType;
import iso.std.iso_iec._24727.tech.schema.DIDQualifierType;
import iso.std.iso_iec._24727.tech.schema.DIDStructureType;
import iso.std.iso_iec._24727.tech.schema.DIDUpdate;
import iso.std.iso_iec._24727.tech.schema.DIDUpdateResponse;
import iso.std.iso_iec._24727.tech.schema.DSICreate;
import iso.std.iso_iec._24727.tech.schema.DSICreateResponse;
import iso.std.iso_iec._24727.tech.schema.DSIDelete;
import iso.std.iso_iec._24727.tech.schema.DSIDeleteResponse;
import iso.std.iso_iec._24727.tech.schema.DSIList;
import iso.std.iso_iec._24727.tech.schema.DSIListResponse;
import iso.std.iso_iec._24727.tech.schema.DSIRead;
import iso.std.iso_iec._24727.tech.schema.DSIReadResponse;
import iso.std.iso_iec._24727.tech.schema.DSIWrite;
import iso.std.iso_iec._24727.tech.schema.DSIWriteResponse;
import iso.std.iso_iec._24727.tech.schema.DataSetCreate;
import iso.std.iso_iec._24727.tech.schema.DataSetCreateResponse;
import iso.std.iso_iec._24727.tech.schema.DataSetDelete;
import iso.std.iso_iec._24727.tech.schema.DataSetDeleteResponse;
import iso.std.iso_iec._24727.tech.schema.DataSetInfoType;
import iso.std.iso_iec._24727.tech.schema.DataSetList;
import iso.std.iso_iec._24727.tech.schema.DataSetListResponse;
import iso.std.iso_iec._24727.tech.schema.DataSetNameListType;
import iso.std.iso_iec._24727.tech.schema.DataSetSelect;
import iso.std.iso_iec._24727.tech.schema.DataSetSelectResponse;
import iso.std.iso_iec._24727.tech.schema.Decipher;
import iso.std.iso_iec._24727.tech.schema.DecipherResponse;
import iso.std.iso_iec._24727.tech.schema.DifferentialIdentityServiceActionName;
import iso.std.iso_iec._24727.tech.schema.Disconnect;
import iso.std.iso_iec._24727.tech.schema.DisconnectResponse;
import iso.std.iso_iec._24727.tech.schema.Encipher;
import iso.std.iso_iec._24727.tech.schema.EncipherResponse;
import iso.std.iso_iec._24727.tech.schema.ExecuteAction;
import iso.std.iso_iec._24727.tech.schema.ExecuteActionResponse;
import iso.std.iso_iec._24727.tech.schema.GetRandom;
import iso.std.iso_iec._24727.tech.schema.GetRandomResponse;
import iso.std.iso_iec._24727.tech.schema.Hash;
import iso.std.iso_iec._24727.tech.schema.HashResponse;
import iso.std.iso_iec._24727.tech.schema.Initialize;
import iso.std.iso_iec._24727.tech.schema.InitializeResponse;
import iso.std.iso_iec._24727.tech.schema.NamedDataServiceActionName;
import iso.std.iso_iec._24727.tech.schema.Sign;
import iso.std.iso_iec._24727.tech.schema.SignResponse;
import iso.std.iso_iec._24727.tech.schema.TargetNameType;
import iso.std.iso_iec._24727.tech.schema.Terminate;
import iso.std.iso_iec._24727.tech.schema.TerminateResponse;
import iso.std.iso_iec._24727.tech.schema.VerifyCertificate;
import iso.std.iso_iec._24727.tech.schema.VerifyCertificateResponse;
import iso.std.iso_iec._24727.tech.schema.VerifySignature;
import iso.std.iso_iec._24727.tech.schema.VerifySignatureResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.openecard.common.ECardException;
import org.openecard.common.WSHelper;
import org.openecard.common.apdu.Select;
import org.openecard.common.apdu.utils.CardUtils;
import org.openecard.common.interfaces.Environment;
import org.openecard.common.interfaces.ProtocolInfo;
import org.openecard.common.sal.Assert;
import org.openecard.common.sal.FunctionType;
import org.openecard.common.sal.Protocol;
import org.openecard.common.sal.ProtocolFactory;
import org.openecard.common.sal.anytype.CryptoMarkerType;
import org.openecard.common.sal.exception.InappropriateProtocolForActionException;
import org.openecard.common.sal.exception.IncorrectParameterException;
import org.openecard.common.sal.exception.UnknownConnectionHandleException;
import org.openecard.common.sal.exception.UnknownProtocolException;
import org.openecard.common.sal.state.CardStateEntry;
import org.openecard.common.sal.state.CardStateMap;
import org.openecard.common.sal.state.cif.CardApplicationWrapper;
import org.openecard.common.sal.state.cif.CardInfoWrapper;
import org.openecard.common.sal.util.SALUtils;
import org.openecard.gui.UserConsent;
import org.openecard.sal.ProtocolFactories;
import org.openecard.ws.SAL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TinySAL
implements SAL {
    private static final Logger logger = LoggerFactory.getLogger(TinySAL.class);
    private final Environment env;
    private final CardStateMap states;
    private ProtocolFactories protocolFactories = new ProtocolFactories();
    private UserConsent userConsent;

    public TinySAL(Environment env, CardStateMap states) {
        this.env = env;
        this.states = states;
    }

    @Override
    public InitializeResponse initialize(Initialize request) {
        return (InitializeResponse)WSHelper.makeResponse(InitializeResponse.class, WSHelper.makeResultUnknownError("Not supported yet."));
    }

    @Override
    public TerminateResponse terminate(Terminate request) {
        return (TerminateResponse)WSHelper.makeResponse(TerminateResponse.class, WSHelper.makeResultUnknownError("Not supported yet."));
    }

    @Override
    public CardApplicationPathResponse cardApplicationPath(CardApplicationPath request) {
        CardApplicationPathResponse response = (CardApplicationPathResponse)WSHelper.makeResponse(CardApplicationPathResponse.class, WSHelper.makeResultOK());
        try {
            CardApplicationPathType cardAppPath = request.getCardAppPathRequest();
            Assert.assertIncorrectParameter(cardAppPath, "The parameter CardAppPathRequest is empty.");
            Set<CardStateEntry> entries = this.states.getMatchingEntries(cardAppPath);
            CardApplicationPathResponse.CardAppPathResultSet resultSet = new CardApplicationPathResponse.CardAppPathResultSet();
            List<CardApplicationPathType> resultPaths = resultSet.getCardApplicationPathResult();
            for (CardStateEntry entry : entries) {
                CardApplicationPathType pathCopy = entry.pathCopy();
                if (cardAppPath.getCardApplication() != null) {
                    pathCopy.setCardApplication(cardAppPath.getCardApplication());
                } else {
                    pathCopy.setCardApplication(entry.getImplicitlySelectedApplicationIdentifier());
                }
                resultPaths.add(pathCopy);
            }
            response.setCardAppPathResultSet(resultSet);
        }
        catch (ECardException e) {
            response.setResult(e.getResult());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            response.setResult(WSHelper.makeResult(e));
        }
        return response;
    }

    @Override
    public CardApplicationConnectResponse cardApplicationConnect(CardApplicationConnect request) {
        CardApplicationConnectResponse response = (CardApplicationConnectResponse)WSHelper.makeResponse(CardApplicationConnectResponse.class, WSHelper.makeResultOK());
        try {
            CardApplicationPathType cardAppPath = request.getCardApplicationPath();
            Assert.assertIncorrectParameter(cardAppPath, "The parameter CardAppPathRequest is empty.");
            Set<CardStateEntry> cardStateEntrySet = this.states.getMatchingEntries(cardAppPath);
            Assert.assertIncorrectParameter(cardStateEntrySet, "The given ConnectionHandle is invalid.");
            CardStateEntry cardStateEntry = cardStateEntrySet.iterator().next();
            byte[] applicationID = cardAppPath.getCardApplication();
            Assert.securityConditionApplication(cardStateEntry, applicationID, ConnectionServiceActionName.CARD_APPLICATION_CONNECT);
            CardApplicationPathType cardApplicationPath = cardStateEntry.pathCopy();
            Connect connect = new Connect();
            connect.setContextHandle(cardApplicationPath.getContextHandle());
            connect.setIFDName(cardApplicationPath.getIFDName());
            connect.setSlot(cardApplicationPath.getSlotIndex());
            ConnectResponse connectResponse = (ConnectResponse)this.env.getDispatcher().deliver(connect);
            WSHelper.checkResult(connectResponse);
            Select select = Arrays.equals(applicationID, Select.MasterFile.MF_FID) ? new Select.MasterFile() : new Select.Application(applicationID);
            select.transmit(this.env.getDispatcher(), connectResponse.getSlotHandle());
            cardStateEntry.setCurrentCardApplication(applicationID);
            cardStateEntry.setSlotHandle(connectResponse.getSlotHandle());
            this.states.addEntry(cardStateEntry);
            response.setConnectionHandle(cardStateEntry.handleCopy());
            response.getConnectionHandle().setCardApplication(applicationID);
        }
        catch (ECardException e) {
            response.setResult(e.getResult());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            response.setResult(WSHelper.makeResult(e));
        }
        return response;
    }

    @Override
    public CardApplicationDisconnectResponse cardApplicationDisconnect(CardApplicationDisconnect request) {
        CardApplicationDisconnectResponse response = (CardApplicationDisconnectResponse)WSHelper.makeResponse(CardApplicationDisconnectResponse.class, WSHelper.makeResultOK());
        try {
            ConnectionHandleType connectionHandle = SALUtils.getConnectionHandle(request);
            byte[] slotHandle = connectionHandle.getSlotHandle();
            if (slotHandle == null) {
                return (CardApplicationDisconnectResponse)WSHelper.makeResponse(CardApplicationDisconnectResponse.class, WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/common#incorrectParameter", "ConnectionHandle is null"));
            }
            Disconnect disconnect = new Disconnect();
            disconnect.setSlotHandle(slotHandle);
            DisconnectResponse disconnectResponse = (DisconnectResponse)this.env.getDispatcher().deliver(disconnect);
            this.states.removeSlotHandleEntry(slotHandle);
            response.setResult(disconnectResponse.getResult());
        }
        catch (ECardException e) {
            response.setResult(e.getResult());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            response.setResult(WSHelper.makeResult(e));
        }
        return response;
    }

    @Override
    public CardApplicationStartSessionResponse cardApplicationStartSession(CardApplicationStartSession request) {
        return (CardApplicationStartSessionResponse)WSHelper.makeResponse(CardApplicationStartSessionResponse.class, WSHelper.makeResultUnknownError("Not supported yet."));
    }

    @Override
    public CardApplicationEndSessionResponse cardApplicationEndSession(CardApplicationEndSession request) {
        return (CardApplicationEndSessionResponse)WSHelper.makeResponse(CardApplicationEndSessionResponse.class, WSHelper.makeResultUnknownError("Not supported yet."));
    }

    @Override
    public CardApplicationListResponse cardApplicationList(CardApplicationList request) {
        CardApplicationListResponse response = (CardApplicationListResponse)WSHelper.makeResponse(CardApplicationListResponse.class, WSHelper.makeResultOK());
        try {
            ConnectionHandleType connectionHandle = SALUtils.getConnectionHandle(request);
            CardStateEntry cardStateEntry = SALUtils.getCardStateEntry(this.states, connectionHandle);
            byte[] cardApplicationID = connectionHandle.getCardApplication();
            Assert.securityConditionApplication(cardStateEntry, cardApplicationID, CardApplicationServiceActionName.CARD_APPLICATION_LIST);
            CardInfoWrapper cardInfoWrapper = cardStateEntry.getInfo();
            CardApplicationListResponse.CardApplicationNameList cardApplicationNameList = new CardApplicationListResponse.CardApplicationNameList();
            cardApplicationNameList.getCardApplicationName().addAll(cardInfoWrapper.getCardApplicationNameList());
            response.setCardApplicationNameList(cardApplicationNameList);
        }
        catch (ECardException e) {
            response.setResult(e.getResult());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            response.setResult(WSHelper.makeResult(e));
        }
        return response;
    }

    @Override
    public CardApplicationCreateResponse cardApplicationCreate(CardApplicationCreate request) {
        return (CardApplicationCreateResponse)WSHelper.makeResponse(CardApplicationCreateResponse.class, WSHelper.makeResultUnknownError("Not supported yet."));
    }

    @Override
    public CardApplicationDeleteResponse cardApplicationDelete(CardApplicationDelete request) {
        return (CardApplicationDeleteResponse)WSHelper.makeResponse(CardApplicationDeleteResponse.class, WSHelper.makeResultUnknownError("Not supported yet."));
    }

    @Override
    public CardApplicationServiceListResponse cardApplicationServiceList(CardApplicationServiceList request) {
        return (CardApplicationServiceListResponse)WSHelper.makeResponse(CardApplicationServiceListResponse.class, WSHelper.makeResultUnknownError("Not supported yet."));
    }

    @Override
    public CardApplicationServiceCreateResponse cardApplicationServiceCreate(CardApplicationServiceCreate request) {
        return (CardApplicationServiceCreateResponse)WSHelper.makeResponse(CardApplicationServiceCreateResponse.class, WSHelper.makeResultUnknownError("Not supported yet."));
    }

    @Override
    public CardApplicationServiceLoadResponse cardApplicationServiceLoad(CardApplicationServiceLoad request) {
        return (CardApplicationServiceLoadResponse)WSHelper.makeResponse(CardApplicationServiceLoadResponse.class, WSHelper.makeResultUnknownError("Not supported yet."));
    }

    @Override
    public CardApplicationServiceDeleteResponse cardApplicationServiceDelete(CardApplicationServiceDelete request) {
        return (CardApplicationServiceDeleteResponse)WSHelper.makeResponse(CardApplicationServiceDeleteResponse.class, WSHelper.makeResultUnknownError("Not supported yet."));
    }

    @Override
    public CardApplicationServiceDescribeResponse cardApplicationServiceDescribe(CardApplicationServiceDescribe request) {
        return (CardApplicationServiceDescribeResponse)WSHelper.makeResponse(CardApplicationServiceDescribeResponse.class, WSHelper.makeResultUnknownError("Not supported yet."));
    }

    @Override
    public ExecuteActionResponse executeAction(ExecuteAction request) {
        return (ExecuteActionResponse)WSHelper.makeResponse(ExecuteActionResponse.class, WSHelper.makeResultUnknownError("Not supported yet."));
    }

    @Override
    public DataSetListResponse dataSetList(DataSetList request) {
        DataSetListResponse response = (DataSetListResponse)WSHelper.makeResponse(DataSetListResponse.class, WSHelper.makeResultOK());
        try {
            ConnectionHandleType connectionHandle = SALUtils.getConnectionHandle(request);
            CardStateEntry cardStateEntry = SALUtils.getCardStateEntry(this.states, connectionHandle);
            byte[] cardApplicationID = connectionHandle.getCardApplication();
            Assert.securityConditionApplication(cardStateEntry, cardApplicationID, NamedDataServiceActionName.DATA_SET_LIST);
            CardInfoWrapper cardInfoWrapper = cardStateEntry.getInfo();
            DataSetNameListType dataSetNameList = cardInfoWrapper.getDataSetNameList(cardApplicationID);
            response.setDataSetNameList(dataSetNameList);
        }
        catch (ECardException e) {
            response.setResult(e.getResult());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            response.setResult(WSHelper.makeResult(e));
        }
        return response;
    }

    @Override
    public DataSetCreateResponse dataSetCreate(DataSetCreate request) {
        return (DataSetCreateResponse)WSHelper.makeResponse(DataSetCreateResponse.class, WSHelper.makeResultUnknownError("Not supported yet."));
    }

    @Override
    public DataSetSelectResponse dataSetSelect(DataSetSelect request) {
        DataSetSelectResponse response = (DataSetSelectResponse)WSHelper.makeResponse(DataSetSelectResponse.class, WSHelper.makeResultOK());
        try {
            ConnectionHandleType connectionHandle = SALUtils.getConnectionHandle(request);
            CardStateEntry cardStateEntry = SALUtils.getCardStateEntry(this.states, connectionHandle);
            byte[] applicationID = connectionHandle.getCardApplication();
            String dataSetName = request.getDataSetName();
            Assert.assertIncorrectParameter(dataSetName, "The parameter DataSetName is empty.");
            CardInfoWrapper cardInfoWrapper = cardStateEntry.getInfo();
            DataSetInfoType dataSetInfo = cardInfoWrapper.getDataSet(dataSetName, applicationID);
            Assert.assertNamedEntityNotFound(dataSetInfo, "The given DataSet cannot be found.");
            Assert.securityConditionDataSet(cardStateEntry, applicationID, dataSetName, NamedDataServiceActionName.DATA_SET_SELECT);
            byte[] fileID = dataSetInfo.getDataSetPath().getEfIdOrPath();
            byte[] slotHandle = connectionHandle.getSlotHandle();
            Select.File selectEF = new Select.File(fileID);
            selectEF.transmit(this.env.getDispatcher(), slotHandle);
        }
        catch (ECardException e) {
            response.setResult(e.getResult());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            response.setResult(WSHelper.makeResult(e));
        }
        return response;
    }

    @Override
    public DataSetDeleteResponse dataSetDelete(DataSetDelete request) {
        return (DataSetDeleteResponse)WSHelper.makeResponse(DataSetDeleteResponse.class, WSHelper.makeResultUnknownError("Not supported yet."));
    }

    @Override
    public DSIListResponse dsiList(DSIList request) {
        return (DSIListResponse)WSHelper.makeResponse(DSIListResponse.class, WSHelper.makeResultUnknownError("Not supported yet."));
    }

    @Override
    public DSICreateResponse dsiCreate(DSICreate request) {
        return (DSICreateResponse)WSHelper.makeResponse(DSICreateResponse.class, WSHelper.makeResultUnknownError("Not supported yet."));
    }

    @Override
    public DSIDeleteResponse dsiDelete(DSIDelete request) {
        return (DSIDeleteResponse)WSHelper.makeResponse(DSIDeleteResponse.class, WSHelper.makeResultUnknownError("Not supported yet."));
    }

    @Override
    public DSIWriteResponse dsiWrite(DSIWrite request) {
        return (DSIWriteResponse)WSHelper.makeResponse(DSIWriteResponse.class, WSHelper.makeResultUnknownError("Not supported yet."));
    }

    @Override
    public DSIReadResponse dsiRead(DSIRead request) {
        DSIReadResponse response = (DSIReadResponse)WSHelper.makeResponse(DSIReadResponse.class, WSHelper.makeResultOK());
        try {
            ConnectionHandleType connectionHandle = SALUtils.getConnectionHandle(request);
            CardStateEntry cardStateEntry = SALUtils.getCardStateEntry(this.states, connectionHandle);
            byte[] applicationID = connectionHandle.getCardApplication();
            String dsiName = request.getDSIName();
            Assert.assertIncorrectParameter(dsiName, "The parameter DSIName is empty.");
            CardInfoWrapper cardInfoWrapper = cardStateEntry.getInfo();
            DataSetInfoType dataSetInfo = cardInfoWrapper.getDataSet(dsiName, applicationID);
            Assert.assertNamedEntityNotFound(dataSetInfo, "The given DSIName cannot be found.");
            Assert.securityConditionDataSet(cardStateEntry, applicationID, dsiName, NamedDataServiceActionName.DSI_READ);
            byte[] fileID = dataSetInfo.getDataSetPath().getEfIdOrPath();
            byte[] slotHandle = connectionHandle.getSlotHandle();
            byte[] fileContent = CardUtils.readFile(this.env.getDispatcher(), slotHandle, fileID);
            response.setDSIContent(fileContent);
        }
        catch (ECardException e) {
            response.setResult(e.getResult());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            response.setResult(WSHelper.makeResult(e));
        }
        return response;
    }

    @Override
    public EncipherResponse encipher(Encipher request) {
        EncipherResponse response = (EncipherResponse)WSHelper.makeResponse(EncipherResponse.class, WSHelper.makeResultOK());
        try {
            ConnectionHandleType connectionHandle = SALUtils.getConnectionHandle(request);
            CardStateEntry cardStateEntry = SALUtils.getCardStateEntry(this.states, connectionHandle);
            byte[] applicationID = connectionHandle.getCardApplication();
            String didName = SALUtils.getDIDName(request);
            byte[] plainText = request.getPlainText();
            Assert.assertIncorrectParameter(plainText, "The parameter PlainText is empty.");
            DIDStructureType didStructure = cardStateEntry.getDIDStructure(didName, applicationID);
            Assert.assertNamedEntityNotFound(didStructure, "The given DIDName cannot be found.");
            String protocolURI = didStructure.getDIDMarker().getProtocol();
            Protocol protocol = this.getProtocol(connectionHandle, protocolURI);
            if (!protocol.hasNextStep(FunctionType.Encipher)) {
                throw new InappropriateProtocolForActionException("Encipher", protocol.toString());
            }
            response = protocol.encipher(request);
            this.removeFinishedProtocol(connectionHandle, protocolURI, protocol);
        }
        catch (ECardException e) {
            response.setResult(e.getResult());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            response.setResult(WSHelper.makeResult(e));
        }
        return response;
    }

    @Override
    public DecipherResponse decipher(Decipher request) {
        DecipherResponse response = (DecipherResponse)WSHelper.makeResponse(DecipherResponse.class, WSHelper.makeResultOK());
        try {
            ConnectionHandleType connectionHandle = SALUtils.getConnectionHandle(request);
            CardStateEntry cardStateEntry = SALUtils.getCardStateEntry(this.states, connectionHandle);
            byte[] applicationID = connectionHandle.getCardApplication();
            String didName = SALUtils.getDIDName(request);
            byte[] cipherText = request.getCipherText();
            Assert.assertIncorrectParameter(cipherText, "The parameter CipherText is empty.");
            DIDStructureType didStructure = cardStateEntry.getDIDStructure(didName, applicationID);
            Assert.assertNamedEntityNotFound(didStructure, "The given DIDName cannot be found.");
            String protocolURI = didStructure.getDIDMarker().getProtocol();
            Protocol protocol = this.getProtocol(connectionHandle, protocolURI);
            if (!protocol.hasNextStep(FunctionType.Decipher)) {
                throw new InappropriateProtocolForActionException("Decipher", protocol.toString());
            }
            response = protocol.decipher(request);
            this.removeFinishedProtocol(connectionHandle, protocolURI, protocol);
        }
        catch (ECardException e) {
            response.setResult(e.getResult());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            response.setResult(WSHelper.makeResult(e));
        }
        return response;
    }

    @Override
    public GetRandomResponse getRandom(GetRandom request) {
        return (GetRandomResponse)WSHelper.makeResponse(GetRandomResponse.class, WSHelper.makeResultUnknownError("Not supported yet."));
    }

    @Override
    public HashResponse hash(Hash request) {
        return (HashResponse)WSHelper.makeResponse(HashResponse.class, WSHelper.makeResultUnknownError("Not supported yet."));
    }

    @Override
    public SignResponse sign(Sign request) {
        SignResponse response = (SignResponse)WSHelper.makeResponse(SignResponse.class, WSHelper.makeResultOK());
        try {
            ConnectionHandleType connectionHandle = SALUtils.getConnectionHandle(request);
            CardStateEntry cardStateEntry = SALUtils.getCardStateEntry(this.states, connectionHandle);
            byte[] applicationID = connectionHandle.getCardApplication();
            String didName = SALUtils.getDIDName(request);
            byte[] message = request.getMessage();
            Assert.assertIncorrectParameter(message, "The parameter Message is empty.");
            DIDStructureType didStructure = cardStateEntry.getDIDStructure(didName, applicationID);
            Assert.assertNamedEntityNotFound(didStructure, "The given DIDName cannot be found.");
            String protocolURI = didStructure.getDIDMarker().getProtocol();
            Protocol protocol = this.getProtocol(connectionHandle, protocolURI);
            if (!protocol.hasNextStep(FunctionType.Sign)) {
                throw new InappropriateProtocolForActionException("Sign", protocol.toString());
            }
            response = protocol.sign(request);
            this.removeFinishedProtocol(connectionHandle, protocolURI, protocol);
        }
        catch (ECardException e) {
            response.setResult(e.getResult());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            response.setResult(WSHelper.makeResult(e));
        }
        return response;
    }

    @Override
    public VerifySignatureResponse verifySignature(VerifySignature request) {
        return (VerifySignatureResponse)WSHelper.makeResponse(VerifySignatureResponse.class, WSHelper.makeResultUnknownError("Not supported yet."));
    }

    @Override
    public VerifyCertificateResponse verifyCertificate(VerifyCertificate request) {
        return (VerifyCertificateResponse)WSHelper.makeResponse(VerifyCertificateResponse.class, WSHelper.makeResultUnknownError("Not supported yet."));
    }

    @Override
    public DIDListResponse didList(DIDList request) {
        DIDListResponse response = (DIDListResponse)WSHelper.makeResponse(DIDListResponse.class, WSHelper.makeResultOK());
        try {
            DIDInfoType next;
            Iterator it;
            CardApplicationWrapper cardApplication;
            ConnectionHandleType connectionHandle = SALUtils.getConnectionHandle(request);
            CardStateEntry cardStateEntry = SALUtils.getCardStateEntry(this.states, connectionHandle);
            byte[] applicationID = connectionHandle.getCardApplication();
            Assert.securityConditionApplication(cardStateEntry, applicationID, DifferentialIdentityServiceActionName.DID_LIST);
            byte[] applicationIDFilter = null;
            String objectIDFilter = null;
            String applicationFunctionFilter = null;
            DIDQualifierType didQualifier = request.getFilter();
            if (didQualifier != null) {
                applicationIDFilter = didQualifier.getApplicationIdentifier();
                objectIDFilter = didQualifier.getObjectIdentifier();
                applicationFunctionFilter = didQualifier.getApplicationFunction();
            }
            if (applicationIDFilter != null) {
                cardApplication = cardStateEntry.getInfo().getCardApplication(applicationIDFilter);
                Assert.assertIncorrectParameter(cardApplication, "The given CardApplication cannot be found.");
            } else {
                cardApplication = cardStateEntry.getCurrentCardApplication();
            }
            ArrayList<DIDInfoType> didInfos = new ArrayList<DIDInfoType>(cardApplication.getDIDInfoList());
            if (objectIDFilter != null) {
                it = didInfos.iterator();
                while (it.hasNext()) {
                    next = (DIDInfoType)it.next();
                    if (next.getDifferentialIdentity().getDIDProtocol().equals(objectIDFilter)) continue;
                    it.remove();
                }
            }
            if (applicationFunctionFilter != null) {
                it = didInfos.iterator();
                while (it.hasNext()) {
                    next = (DIDInfoType)it.next();
                    if (next.getDifferentialIdentity().getDIDMarker().getCryptoMarker() == null) {
                        it.remove();
                        continue;
                    }
                    CryptoMarkerType cryptoMarker = new CryptoMarkerType(next.getDifferentialIdentity().getDIDMarker().getCryptoMarker());
                    if (cryptoMarker.getAlgorithmInfo().getSupportedOperations().contains(applicationFunctionFilter)) continue;
                    it.remove();
                }
            }
            DIDNameListType didNameList = new DIDNameListType();
            for (DIDInfoType didInfo : didInfos) {
                didNameList.getDIDName().add(didInfo.getDifferentialIdentity().getDIDName());
            }
            response.setDIDNameList(didNameList);
        }
        catch (ECardException e) {
            response.setResult(e.getResult());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            response.setResult(WSHelper.makeResult(e));
        }
        return response;
    }

    @Override
    public DIDCreateResponse didCreate(DIDCreate request) {
        return (DIDCreateResponse)WSHelper.makeResponse(DIDCreateResponse.class, WSHelper.makeResultUnknownError("Not supported yet."));
    }

    @Override
    public DIDGetResponse didGet(DIDGet request) {
        DIDGetResponse response = (DIDGetResponse)WSHelper.makeResponse(DIDGetResponse.class, WSHelper.makeResultOK());
        try {
            ConnectionHandleType connectionHandle = SALUtils.getConnectionHandle(request);
            CardStateEntry cardStateEntry = SALUtils.getCardStateEntry(this.states, connectionHandle);
            String didName = SALUtils.getDIDName(request);
            DIDStructureType didStructure = SALUtils.getDIDStructure(request, didName, cardStateEntry, connectionHandle);
            String protocolURI = didStructure.getDIDMarker().getProtocol();
            Protocol protocol = this.getProtocol(connectionHandle, protocolURI);
            if (!protocol.hasNextStep(FunctionType.DIDGet)) {
                throw new InappropriateProtocolForActionException("DIDGet", protocol.toString());
            }
            response = protocol.didGet(request);
            this.removeFinishedProtocol(connectionHandle, protocolURI, protocol);
        }
        catch (ECardException e) {
            response.setResult(e.getResult());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            response.setResult(WSHelper.makeResult(e));
        }
        return response;
    }

    @Override
    public DIDUpdateResponse didUpdate(DIDUpdate request) {
        return (DIDUpdateResponse)WSHelper.makeResponse(DIDUpdateResponse.class, WSHelper.makeResultUnknownError("Not supported yet."));
    }

    @Override
    public DIDDeleteResponse didDelete(DIDDelete request) {
        return (DIDDeleteResponse)WSHelper.makeResponse(DIDDeleteResponse.class, WSHelper.makeResultUnknownError("Not supported yet."));
    }

    @Override
    public DIDAuthenticateResponse didAuthenticate(DIDAuthenticate request) {
        DIDAuthenticateResponse response = (DIDAuthenticateResponse)WSHelper.makeResponse(DIDAuthenticateResponse.class, WSHelper.makeResultOK());
        try {
            ConnectionHandleType connectionHandle = SALUtils.getConnectionHandle(request);
            DIDAuthenticationDataType didAuthenticationData = request.getAuthenticationProtocolData();
            Assert.assertIncorrectParameter(didAuthenticationData, "The parameter AuthenticationProtocolData is empty.");
            String protocolURI = request.getAuthenticationProtocolData().getProtocol();
            if (protocolURI == null) {
                logger.warn("ProtocolURI was null");
                protocolURI = "urn:oid:1.3.162.15480.3.0.14";
            } else if (protocolURI.equals("urn:oid:1.0.24727.3.0.0.7.2")) {
                logger.warn("ProtocolURI was urn:oid:1.0.24727.3.0.0.7.2");
                protocolURI = "urn:oid:1.3.162.15480.3.0.14";
            }
            Protocol protocol = this.getProtocol(connectionHandle, protocolURI);
            if (!protocol.hasNextStep(FunctionType.DIDAuthenticate)) {
                throw new InappropriateProtocolForActionException("DIDAuthenticate", protocol.toString());
            }
            response = protocol.didAuthenticate(request);
            this.removeFinishedProtocol(connectionHandle, protocolURI, protocol);
        }
        catch (ECardException e) {
            response.setResult(e.getResult());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            response.setResult(WSHelper.makeResult(e));
        }
        return response;
    }

    @Override
    public ACLListResponse aclList(ACLList request) {
        ACLListResponse response;
        block6: {
            response = (ACLListResponse)WSHelper.makeResponse(ACLListResponse.class, WSHelper.makeResultOK());
            try {
                ConnectionHandleType connectionHandle = SALUtils.getConnectionHandle(request);
                CardStateEntry cardStateEntry = SALUtils.getCardStateEntry(this.states, connectionHandle);
                TargetNameType targetName = request.getTargetName();
                Assert.assertIncorrectParameter(targetName, "The parameter TargetName is empty.");
                String dataSetName = targetName.getDataSetName();
                String didName = targetName.getDIDName() != null ? SALUtils.getDIDName(targetName) : null;
                byte[] cardApplicationID = targetName.getCardApplicationName();
                CardInfoWrapper cardInfoWrapper = cardStateEntry.getInfo();
                byte[] applicationIdentifier = connectionHandle.getCardApplication();
                if (dataSetName != null) {
                    DataSetInfoType dataSetInfo = cardInfoWrapper.getDataSet(dataSetName, applicationIdentifier);
                    Assert.assertNamedEntityNotFound(dataSetInfo, "The given DataSet cannot be found.");
                    response.setTargetACL(cardInfoWrapper.getDataSet(dataSetName, applicationIdentifier).getDataSetACL());
                    break block6;
                }
                if (didName != null) {
                    DIDInfoType didInfo = cardInfoWrapper.getDIDInfo(didName, applicationIdentifier);
                    Assert.assertNamedEntityNotFound(didInfo, "The given DIDInfo cannot be found.");
                    response.setTargetACL(cardInfoWrapper.getDIDInfo(didName, applicationIdentifier).getDIDACL());
                    break block6;
                }
                if (cardApplicationID != null) {
                    CardApplicationWrapper cardApplication = cardInfoWrapper.getCardApplication(cardApplicationID);
                    Assert.assertNamedEntityNotFound(cardApplication, "The given CardApplication cannot be found.");
                    Assert.securityConditionApplication(cardStateEntry, cardApplicationID, AuthorizationServiceActionName.ACL_LIST);
                    response.setTargetACL(cardInfoWrapper.getCardApplication(cardApplicationID).getCardApplicationACL());
                    break block6;
                }
                throw new IncorrectParameterException("The given TargetName is invalid.");
            }
            catch (ECardException e) {
                response.setResult(e.getResult());
            }
            catch (Exception e) {
                logger.error(e.getMessage(), e);
                response.setResult(WSHelper.makeResult(e));
            }
        }
        return response;
    }

    @Override
    public ACLModifyResponse aclModify(ACLModify request) {
        return (ACLModifyResponse)WSHelper.makeResponse(ACLModifyResponse.class, WSHelper.makeResultUnknownError("Not supported yet."));
    }

    public void setGUI(UserConsent uc) {
        this.userConsent = uc;
    }

    public List<ConnectionHandleType> getConnectionHandles() {
        ConnectionHandleType handle = new ConnectionHandleType();
        Set<CardStateEntry> entries = this.states.getMatchingEntries(handle);
        ArrayList<ConnectionHandleType> result = new ArrayList<ConnectionHandleType>(entries.size());
        for (CardStateEntry entry : entries) {
            result.add(entry.handleCopy());
        }
        return result;
    }

    @Nonnull
    public ProtocolInfo getProtocolInfo() {
        return this.protocolFactories;
    }

    public boolean addProtocol(String protocolURI, ProtocolFactory factory) {
        return this.protocolFactories.add(protocolURI, factory);
    }

    public void removeFinishedProtocol(ConnectionHandleType handle, String protocolURI, Protocol protocol) throws UnknownConnectionHandleException {
        if (protocol.isFinished()) {
            CardStateEntry entry = SALUtils.getCardStateEntry(this.states, handle);
            entry.removeProtocol(protocolURI);
        }
    }

    private Protocol getProtocol(ConnectionHandleType handle, String protocolURI) throws UnknownProtocolException, UnknownConnectionHandleException {
        CardStateEntry entry = SALUtils.getCardStateEntry(this.states, handle);
        Protocol protocol = entry.getProtocol(protocolURI);
        if (protocol == null) {
            if (this.protocolFactories.contains(protocolURI)) {
                protocol = this.protocolFactories.get(protocolURI).createInstance(this.env.getDispatcher(), this.userConsent);
                entry.setProtocol(protocolURI, protocol);
            } else {
                throw new UnknownProtocolException("The protocol URI '" + protocolURI + "' is not registered in this SAL component.");
            }
        }
        protocol.getInternalData().put("cardState", entry);
        return protocol;
    }
}

