/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.gui.settings;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.openecard.common.I18n;
import org.openecard.gui.graphics.GraphicsUtil;
import org.openecard.gui.graphics.OecLogoBgWhite;
import org.openecard.gui.settings.PreferencesListSelectionListener;

public class SettingsDialog
extends JDialog {
    private final I18n lang = I18n.getTranslation("settings");
    private static final long serialVersionUID = 1L;
    private final int width = 720;
    private final int height = 480;
    private final int columnwidth = 144;
    private final int columnheight = 380;
    private final Dimension columnDimension = new Dimension(144, 380);
    private final Border defaultBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
    private JPanel middleListPane;
    private JPanel rightPane;
    private JPanel listPanePreferences;
    private JPanel mainPane;

    public SettingsDialog() {
        this.setupUI();
    }

    public JPanel getRightPane() {
        return this.rightPane;
    }

    public JPanel getMiddleListPane() {
        return this.middleListPane;
    }

    public Border getDefaultBorder() {
        return this.defaultBorder;
    }

    public int getColumnwidth() {
        return 144;
    }

    public int getColumnheight() {
        return 380;
    }

    public Dimension getColumnDimension() {
        return this.columnDimension;
    }

    public JPanel getMainPane() {
        return this.mainPane;
    }

    public static void showDialog() {
        SettingsDialog dialog = new SettingsDialog();
        dialog.setVisible(true);
    }

    private void setupUI() {
        Image logo = GraphicsUtil.createImage(OecLogoBgWhite.class, 147, 147);
        this.setSize(720, 480);
        this.setIconImage(logo);
        this.setTitle(this.lang.translationForKey("settings.title", new Object[0]));
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        this.getContentPane().setBackground(null);
        this.getContentPane().setLayout(new GridBagLayout());
        this.middleListPane = this.createMiddleListPane();
        this.listPanePreferences = this.createPreferencesListPane();
        this.mainPane = this.createMainPane();
        this.rightPane = this.createRightPane();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.getContentPane().add((Component)this.mainPane, gbc);
        JPanel buttonPane = this.createButtonPane();
        gbc.gridy = 1;
        gbc.fill = 2;
        this.getContentPane().add((Component)buttonPane, gbc);
    }

    private JPanel createRightPane() {
        JPanel p = new JPanel();
        p.setBackground(null);
        p.setBorder(new EmptyBorder(0, 0, 0, 0));
        return p;
    }

    private JPanel createMainPane() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 2));
        p.setBackground(null);
        p.add(this.listPanePreferences);
        return p;
    }

    private JPanel createPreferencesListPane() {
        JList<Object> listPreferences = new JList<Object>(new Object[]{"Plugins"});
        listPreferences.setSelectionMode(0);
        listPreferences.setLayoutOrientation(0);
        listPreferences.setVisibleRowCount(-1);
        JScrollPane listScrollerPreferences = new JScrollPane(listPreferences);
        listScrollerPreferences.setPreferredSize(this.columnDimension);
        listPreferences.addListSelectionListener(new PreferencesListSelectionListener(this));
        JPanel preferences = new JPanel();
        preferences.setLayout(new BoxLayout(preferences, 3));
        preferences.add(listScrollerPreferences);
        preferences.setBorder(this.defaultBorder);
        preferences.setMaximumSize(new Dimension(144, Integer.MAX_VALUE));
        preferences.setBackground(null);
        return preferences;
    }

    private JPanel createMiddleListPane() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 3));
        p.setMaximumSize(new Dimension(144, Integer.MAX_VALUE));
        p.setBorder(this.defaultBorder);
        p.setBackground(null);
        return p;
    }

    private JPanel createButtonPane() {
        JButton btnClose = new JButton(this.lang.translationForKey("settings.button.close", new Object[0]));
        btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsDialog.this.dispose();
            }
        });
        JPanel buttonPane = new JPanel();
        buttonPane.setBackground(null);
        buttonPane.setLayout(new BoxLayout(buttonPane, 2));
        buttonPane.setBorder(this.defaultBorder);
        buttonPane.add(Box.createHorizontalGlue());
        buttonPane.add(btnClose);
        return buttonPane;
    }
}

