/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.ifd;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;

public class PACECapabilities {
    private final BitSet capabilities;

    public PACECapabilities(byte[] capabilitiesStructure) {
        if (capabilitiesStructure.length == 1) {
            this.capabilities = this.makeBitSet(capabilitiesStructure);
        } else {
            byte length = capabilitiesStructure[0];
            byte[] data = Arrays.copyOfRange(capabilitiesStructure, 1, length + 1);
            this.capabilities = this.makeBitSet(data);
        }
    }

    public List<Long> getFeatures() {
        ArrayList<Long> result = new ArrayList<Long>(this.capabilities.cardinality());
        int i = this.capabilities.nextSetBit(0);
        while (i >= 0) {
            result.add(Long.valueOf(1 << i));
            i = this.capabilities.nextSetBit(i + 1);
        }
        return result;
    }

    public List<PACECapability> getFeaturesEnum() {
        List<Long> features = this.getFeatures();
        ArrayList<PACECapability> result = new ArrayList<PACECapability>(features.size());
        for (Long next : features) {
            PACECapability cap = PACECapability.getCapability(next);
            if (next == null) continue;
            result.add(cap);
        }
        return result;
    }

    private BitSet makeBitSet(byte[] d) {
        BitSet b = new BitSet(d.length * 8);
        for (int i = 0; i < d.length; ++i) {
            byte next = d[i];
            for (int j = 0; j < 8; ++j) {
                boolean isSet;
                boolean bl = isSet = (next >> j & 1) == 1;
                if (!isSet) continue;
                b.set(i * 8 + j);
            }
        }
        return b;
    }

    public static enum PACECapability {
        DestroyPACEChannel(128L),
        GenericPACE(64L),
        GermanEID(32L),
        QES(16L);

        public final long number;

        private PACECapability(long number) {
            this.number = number;
        }

        public static PACECapability getCapability(long number) {
            for (PACECapability next : PACECapability.values()) {
                if (next.number != number) continue;
                return next;
            }
            return null;
        }

        public String getProtocol() {
            return "urn:oid:0.4.0.127.0.7.2.2.4." + this.number;
        }
    }
}

