/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.ws.jaxb;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarshallerImpl {
    private static final Logger logger = LoggerFactory.getLogger(MarshallerImpl.class);
    private static final List<Class> baseXmlElementClasses;
    private static final JAXBContext baseJaxbContext;
    private boolean userOverride = false;
    private final Set<Class> userClasses = new HashSet<Class>(baseXmlElementClasses);
    private Marshaller marshaller;
    private Unmarshaller unmarshaller;

    public synchronized void addXmlClass(Class c) {
        if (!this.userClasses.contains(c)) {
            this.userClasses.add(c);
            this.userOverride = true;
            this.resetMarshaller();
        }
    }

    public synchronized void removeAllClasses() {
        this.userOverride = true;
        this.userClasses.clear();
        this.resetMarshaller();
    }

    public synchronized Marshaller getMarshaller() throws JAXBException {
        if (this.marshaller == null) {
            this.loadInstances();
        }
        return this.marshaller;
    }

    public synchronized Unmarshaller getUnmarshaller() throws JAXBException {
        if (this.unmarshaller == null) {
            this.loadInstances();
        }
        return this.unmarshaller;
    }

    private void resetMarshaller() {
        this.marshaller = null;
        this.unmarshaller = null;
    }

    private void loadInstances() throws JAXBException {
        JAXBContext jaxbCtx = this.userOverride ? JAXBContext.newInstance((Class[])this.userClasses.toArray(new Class[this.userClasses.size()])) : baseJaxbContext;
        this.marshaller = jaxbCtx.createMarshaller();
        this.unmarshaller = jaxbCtx.createUnmarshaller();
    }

    private static Class[] getJaxbClasses() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        LinkedList classes = new LinkedList();
        InputStream classListStream = cl.getResourceAsStream("classes.lst");
        InputStream classListStreamC = cl.getResourceAsStream("/classes.lst");
        try {
            String next;
            if (classListStream == null && classListStreamC == null) {
                throw new IOException("Failed to load classes.lst.");
            }
            classListStream = classListStream != null ? classListStream : classListStreamC;
            LineNumberReader r = new LineNumberReader(new InputStreamReader(classListStream));
            while ((next = r.readLine()) != null) {
                try {
                    Class<?> c = cl.loadClass(next);
                    if (!MarshallerImpl.isJaxbClass(c)) continue;
                    classes.add(c);
                }
                catch (ClassNotFoundException ex) {
                    logger.error("Failed to load class: " + next, ex);
                }
            }
        }
        catch (IOException ex) {
            logger.error("Failed to read classes from file classes.lst.", ex);
        }
        return classes.toArray(new Class[classes.size()]);
    }

    private static boolean isJaxbClass(Class<?> c) {
        return c.getAnnotation(XmlType.class) != null;
    }

    static {
        Class[] jaxbClasses = MarshallerImpl.getJaxbClasses();
        baseXmlElementClasses = new ArrayList<Class>(jaxbClasses.length);
        baseXmlElementClasses.addAll(Arrays.asList(jaxbClasses));
        try {
            baseJaxbContext = JAXBContext.newInstance((Class[])jaxbClasses);
        }
        catch (JAXBException ex) {
            logger.error("Failed to create JAXBContext instance.", ex);
            throw new RuntimeException("Failed to create JAXBContext.");
        }
    }
}

