/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.richclient.gui.manage.core;

import java.util.Map;
import org.openecard.common.I18n;
import org.openecard.plugins.PluginAction;
import org.openecard.plugins.PluginInterface;
import org.openecard.plugins.manager.PluginManager;
import org.openecard.richclient.gui.manage.ActionEntryPanel;
import org.openecard.richclient.gui.manage.ActionPanel;

public class PINActionPanel
extends ActionPanel {
    private static final long serialVersionUID = 1L;
    private static final String CHANGE = "addon.list.core.pin_management.change_pin";
    private static final String CHANGE_DESC = "addon.list.core.pin_management.change_pin.desc";
    private static final String UNBLOCK = "addon.list.core.pin_management.unblock_pin";
    private static final String UNBLOCK_DESC = "addon.list.core.pin_management.unblock_pin.desc";
    private final I18n lang = I18n.getTranslation("addon");

    public PINActionPanel() {
        PluginAction changePinAction = null;
        PluginAction unblockPinAction = null;
        Map<PluginInterface, Boolean> plugins = PluginManager.getLoadedPlugins();
        for (PluginInterface plugin : plugins.keySet()) {
            for (PluginAction action : plugin.getActions()) {
                if ("ChangePINAction".equals(action.getID())) {
                    changePinAction = action;
                    continue;
                }
                if (!"UnblockPINAction".equals(action.getID())) continue;
                unblockPinAction = action;
            }
        }
        String changePinName = this.lang.translationForKey(CHANGE, new Object[0]);
        String changePinDesc = this.lang.translationForKey(CHANGE_DESC, new Object[0]);
        ActionEntryPanel changePin = new ActionEntryPanel(changePinName, changePinDesc);
        changePin.addAction(changePinAction);
        this.addActionEntry(changePin);
        String unblockPinName = this.lang.translationForKey(UNBLOCK, new Object[0]);
        String unblockPinDesc = this.lang.translationForKey(UNBLOCK_DESC, new Object[0]);
        ActionEntryPanel unblockPin = new ActionEntryPanel(unblockPinName, unblockPinDesc);
        unblockPin.addAction(unblockPinAction);
        this.addActionEntry(unblockPin);
    }
}

