/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.apdu;

import org.openecard.common.apdu.common.CardCommandAPDU;
import org.openecard.common.util.ShortUtils;

public class Select
extends CardCommandAPDU {
    private static final byte SELECT_INS = -92;
    private static final byte FCI = 0;
    private static final byte FCP = 4;
    private static final byte FMD = 8;

    public Select(byte p1, byte p2) {
        super((byte)0, (byte)-92, p1, p2);
    }

    public void setFCI() {
        this.setP2((byte)0);
        this.setLE((byte)-1);
    }

    public void setFCP() {
        this.setP2((byte)4);
        this.setLE((byte)-1);
    }

    public void setFMD() {
        this.setP2((byte)8);
        this.setLE((byte)-1);
    }

    public static final class RelativePath
    extends Select {
        public RelativePath(byte[] aid) {
            super((byte)9, (byte)12);
            this.setData(aid);
        }
    }

    public static final class AbsolutePath
    extends Select {
        public AbsolutePath(byte[] aid) {
            super((byte)8, (byte)12);
            this.setData(aid);
        }
    }

    public static final class Application
    extends Select {
        public Application(byte[] aid) {
            super((byte)4, (byte)12);
            this.setData(aid);
        }
    }

    public static final class Parent
    extends Select {
        public Parent() {
            super((byte)3, (byte)12);
        }
    }

    public static final class File
    extends Select {
        public File(byte[] fid) {
            super((byte)2, (byte)12);
            this.setData(fid);
        }

        public File(short fid) {
            this(ShortUtils.toByteArray(fid));
        }
    }

    public static final class Directory
    extends Select {
        public Directory(byte[] fid) {
            super((byte)1, (byte)12);
            this.setData(fid);
        }
    }

    public static final class MasterFile
    extends Select {
        public static final byte[] MF_FID = new byte[]{63, 0};

        public MasterFile() {
            super((byte)0, (byte)12);
            this.setData(MF_FID);
        }
    }
}

