/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.ifd.protocol.pace.crypto;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.openecard.bouncycastle.jce.spec.ECParameterSpec;
import org.openecard.bouncycastle.math.ec.ECPoint;
import org.openecard.common.util.ByteUtils;
import org.openecard.crypto.common.asn1.eac.PACEDomainParameter;
import org.openecard.crypto.common.asn1.eac.PACESecurityInfos;
import org.openecard.ifd.protocol.pace.crypto.PACEGenericMapping;
import org.openecard.ifd.protocol.pace.crypto.PACEIntegratedMapping;
import org.openecard.ifd.protocol.pace.crypto.PACEMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PACECryptoSuite {
    private static final Logger logger = LoggerFactory.getLogger(PACECryptoSuite.class.getName());
    private PACESecurityInfos psi;
    private PACEDomainParameter domainParameter;

    public PACECryptoSuite(PACESecurityInfos psi, PACEDomainParameter pdp) throws GeneralSecurityException {
        this.psi = psi;
        this.domainParameter = pdp;
    }

    public byte[] decryptNonce(byte[] keyData, byte[] nonceData) throws GeneralSecurityException {
        byte[] ret = new byte[16];
        byte[] nonce = ByteUtils.copy(nonceData, 4, nonceData.length - 4);
        try {
            Cipher c = Cipher.getInstance("AES/CBC/NoPadding");
            SecretKeySpec skeySpec = new SecretKeySpec(keyData, "AES");
            IvParameterSpec params = new IvParameterSpec(new byte[16]);
            c.init(2, (Key)skeySpec, params);
            c.doFinal(nonce, 0, nonce.length, ret);
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
            throw new GeneralSecurityException(e);
        }
        return ret;
    }

    public byte[] generateSharedSecret(byte[] sk, byte[] pk) {
        if (this.domainParameter.isDH()) {
            throw new UnsupportedOperationException("Not implemented yet!");
        }
        if (this.domainParameter.isECDH()) {
            ECParameterSpec p = (ECParameterSpec)this.domainParameter.getParameter();
            if (p.getH().intValue() == 1) {
                BigInteger d = new BigInteger(1, sk);
                ECPoint q = p.getCurve().decodePoint(pk);
                ECPoint k = q.multiply(d);
                return ByteUtils.cutLeadingNullBytes(k.getX().toBigInteger().toByteArray());
            }
            throw new UnsupportedOperationException("Not implemented yet!");
        }
        throw new IllegalArgumentException();
    }

    public PACEMapping getMapping() {
        if (this.psi.getPACEInfo().isGM()) {
            return new PACEGenericMapping(this.domainParameter);
        }
        if (this.psi.getPACEInfo().isIM()) {
            return new PACEIntegratedMapping(this.domainParameter);
        }
        throw new IllegalArgumentException();
    }
}

