/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.crypto.tls;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.openecard.bouncycastle.crypto.Digest;
import org.openecard.bouncycastle.crypto.Mac;
import org.openecard.bouncycastle.crypto.digests.LongDigest;
import org.openecard.bouncycastle.crypto.macs.HMac;
import org.openecard.bouncycastle.crypto.params.KeyParameter;
import org.openecard.bouncycastle.crypto.tls.ProtocolVersion;
import org.openecard.bouncycastle.crypto.tls.SSL3Mac;
import org.openecard.bouncycastle.crypto.tls.TlsContext;
import org.openecard.bouncycastle.crypto.tls.TlsUtils;
import org.openecard.bouncycastle.util.Arrays;

public class TlsMac {
    protected TlsContext context;
    protected byte[] secret;
    protected Mac mac;
    protected int digestBlockSize;
    protected int digestOverhead;

    public TlsMac(TlsContext context, Digest digest, byte[] key, int keyOff, int keyLen) {
        this.context = context;
        KeyParameter keyParameter = new KeyParameter(key, keyOff, keyLen);
        this.secret = Arrays.clone(keyParameter.getKey());
        if (digest instanceof LongDigest) {
            this.digestBlockSize = 128;
            this.digestOverhead = 16;
        } else {
            this.digestBlockSize = 64;
            this.digestOverhead = 8;
        }
        if (context.getServerVersion().isSSL()) {
            this.mac = new SSL3Mac(digest);
            if (digest.getDigestSize() == 20) {
                this.digestOverhead = 4;
            }
        } else {
            this.mac = new HMac(digest);
        }
        this.mac.init(keyParameter);
    }

    public byte[] getMACSecret() {
        return this.secret;
    }

    public int getSize() {
        return this.mac.getMacSize();
    }

    public byte[] calculateMac(long seqNo, short type, byte[] message, int offset, int length) {
        ProtocolVersion serverVersion = this.context.getServerVersion();
        boolean isSSL = serverVersion.isSSL();
        ByteArrayOutputStream bosMac = new ByteArrayOutputStream(isSSL ? 11 : 13);
        try {
            TlsUtils.writeUint64(seqNo, bosMac);
            TlsUtils.writeUint8(type, bosMac);
            if (!isSSL) {
                TlsUtils.writeVersion(serverVersion, bosMac);
            }
            TlsUtils.writeUint16(length, bosMac);
        }
        catch (IOException e) {
            throw new IllegalStateException("Internal error during mac calculation");
        }
        byte[] macHeader = bosMac.toByteArray();
        this.mac.update(macHeader, 0, macHeader.length);
        this.mac.update(message, offset, length);
        byte[] result = new byte[this.mac.getMacSize()];
        this.mac.doFinal(result, 0);
        return result;
    }

    public byte[] calculateMacConstantTime(long seqNo, short type, byte[] message, int offset, int length, int fullLength, byte[] dummyData) {
        byte[] result = this.calculateMac(seqNo, type, message, offset, length);
        int headerLength = this.context.getServerVersion().isSSL() ? 11 : 13;
        int extra = this.getDigestBlockCount(headerLength + fullLength) - this.getDigestBlockCount(headerLength + length);
        while (--extra >= 0) {
            this.mac.update(dummyData, 0, this.digestBlockSize);
        }
        this.mac.update(dummyData[0]);
        this.mac.reset();
        return result;
    }

    private int getDigestBlockCount(int inputLength) {
        return (inputLength + this.digestOverhead) / this.digestBlockSize;
    }
}

