/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.crypto.tls;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.openecard.bouncycastle.asn1.ASN1InputStream;
import org.openecard.bouncycastle.asn1.ASN1Primitive;
import org.openecard.bouncycastle.crypto.tls.TlsProtocol;
import org.openecard.bouncycastle.crypto.tls.TlsUtils;

public class Certificate {
    public static final Certificate EMPTY_CHAIN = new Certificate(new org.openecard.bouncycastle.asn1.x509.Certificate[0]);
    protected org.openecard.bouncycastle.asn1.x509.Certificate[] certificateList;

    public Certificate(org.openecard.bouncycastle.asn1.x509.Certificate[] certificateList) {
        if (certificateList == null) {
            throw new IllegalArgumentException("'certificateList' cannot be null");
        }
        this.certificateList = certificateList;
    }

    public org.openecard.bouncycastle.asn1.x509.Certificate[] getCerts() {
        return this.clone(this.certificateList);
    }

    public org.openecard.bouncycastle.asn1.x509.Certificate[] getCertificateList() {
        return this.clone(this.certificateList);
    }

    public org.openecard.bouncycastle.asn1.x509.Certificate getCertificateAt(int index) {
        return this.certificateList[index];
    }

    public int getLength() {
        return this.certificateList.length;
    }

    public boolean isEmpty() {
        return this.certificateList.length == 0;
    }

    public void encode(OutputStream output) throws IOException {
        byte[] encCert;
        int i;
        Vector<byte[]> encCerts = new Vector<byte[]>(this.certificateList.length);
        int totalLength = 0;
        for (i = 0; i < this.certificateList.length; ++i) {
            encCert = this.certificateList[i].getEncoded("DER");
            encCerts.addElement(encCert);
            totalLength += encCert.length + 3;
        }
        TlsUtils.writeUint24(totalLength, output);
        for (i = 0; i < encCerts.size(); ++i) {
            encCert = (byte[])encCerts.elementAt(i);
            TlsUtils.writeOpaque24(encCert, output);
        }
    }

    public static Certificate parse(InputStream input) throws IOException {
        int left = TlsUtils.readUint24(input);
        if (left == 0) {
            return EMPTY_CHAIN;
        }
        Vector<org.openecard.bouncycastle.asn1.x509.Certificate> tmp = new Vector<org.openecard.bouncycastle.asn1.x509.Certificate>();
        while (left > 0) {
            int size = TlsUtils.readUint24(input);
            left -= 3 + size;
            byte[] buf = TlsUtils.readFully(size, input);
            ByteArrayInputStream bis = new ByteArrayInputStream(buf);
            ASN1Primitive asn1 = new ASN1InputStream(bis).readObject();
            TlsProtocol.assertEmpty(bis);
            tmp.addElement(org.openecard.bouncycastle.asn1.x509.Certificate.getInstance(asn1));
        }
        org.openecard.bouncycastle.asn1.x509.Certificate[] certs = new org.openecard.bouncycastle.asn1.x509.Certificate[tmp.size()];
        for (int i = 0; i < tmp.size(); ++i) {
            certs[i] = (org.openecard.bouncycastle.asn1.x509.Certificate)tmp.elementAt(i);
        }
        return new Certificate(certs);
    }

    private org.openecard.bouncycastle.asn1.x509.Certificate[] clone(org.openecard.bouncycastle.asn1.x509.Certificate[] list) {
        org.openecard.bouncycastle.asn1.x509.Certificate[] rv = new org.openecard.bouncycastle.asn1.x509.Certificate[list.length];
        System.arraycopy(list, 0, rv, 0, rv.length);
        return rv;
    }
}

