/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.transport.httpcore;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.openecard.apache.http.impl.io.AbstractSessionInputBuffer;
import org.openecard.apache.http.params.HttpParams;

public class StreamSessionInputBuffer
extends AbstractSessionInputBuffer {
    private static final ExecutorService exec = Executors.newCachedThreadPool();

    public StreamSessionInputBuffer(InputStream in, int bufsize, HttpParams params) {
        this.init(new BufferedInputStream(in, bufsize), bufsize, params);
    }

    @Override
    public boolean isDataAvailable(int timeout) throws IOException {
        Future<Boolean> task = exec.submit(new DataAvailabilityChecker());
        try {
            if (timeout == 0) {
                return task.get();
            }
            return task.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException ex) {
            throw new IOException("Wait for data timed out.", ex);
        }
        catch (ExecutionException ex) {
            throw (IOException)ex.getCause();
        }
        catch (InterruptedException ex) {
            return false;
        }
    }

    private class DataAvailabilityChecker
    implements Callable<Boolean> {
        private DataAvailabilityChecker() {
        }

        @Override
        public Boolean call() throws IOException {
            boolean result = StreamSessionInputBuffer.this.hasBufferedData();
            if (!result) {
                StreamSessionInputBuffer.this.fillBuffer();
                result = StreamSessionInputBuffer.this.hasBufferedData();
            }
            return result;
        }
    }
}

