/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.richclient.gui.manage.core;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.openecard.common.OpenecardProperties;
import org.openecard.common.io.ProxySettings;
import org.openecard.common.util.FileUtils;
import org.openecard.richclient.gui.manage.SettingsGroup;

public class ProxySettingsGroup
extends SettingsGroup {
    private static final long serialVersionUID = 1L;
    private final JComboBox selection = this.addSelectionItem("Proxy Type", null, "proxy.scheme", "", "SOCKS", "HTTP", "HTTPS");
    private final JTextField host = this.addInputItem("Hostname", null, "proxy.host");
    private final JTextField port = this.addInputItem("Port", null, "proxy.port");
    private final JCheckBox vali = this.addBoolItem("Validate TLS", "Validation of the certificate of the proxy server.", "proxy.validate_tls");
    private final JTextField user = this.addInputItem("Username", null, "proxy.user");
    private final JTextField pass = this.addInputItem("Password", null, "proxy.pass");

    public ProxySettingsGroup() {
        super(null, OpenecardProperties.properties());
        ItemManager manager = new ItemManager();
        Object selectedItem = this.selection.getSelectedItem();
        ItemEvent trigger = new ItemEvent(this.selection, 701, selectedItem, 1);
        manager.itemStateChanged(trigger);
        this.selection.addItemListener(manager);
    }

    @Override
    protected void saveProperties() throws IOException, SecurityException {
        File home = FileUtils.getHomeConfigDir();
        File config = new File(home, "openecard.properties");
        FileWriter writer = new FileWriter(config);
        this.properties.store(writer, null);
        OpenecardProperties.load();
        ProxySettings.load();
    }

    private class ItemManager
    implements ItemListener {
        private ItemManager() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                Object val = e.getItem();
                if ("SOCKS".equals(val)) {
                    ProxySettingsGroup.this.setEnabledComponent(ProxySettingsGroup.this.host, true);
                    ProxySettingsGroup.this.setEnabledComponent(ProxySettingsGroup.this.port, true);
                    ProxySettingsGroup.this.setEnabledComponent(ProxySettingsGroup.this.vali, false);
                    ProxySettingsGroup.this.setEnabledComponent(ProxySettingsGroup.this.user, false);
                    ProxySettingsGroup.this.setEnabledComponent(ProxySettingsGroup.this.pass, false);
                } else if ("HTTP".equals(val)) {
                    ProxySettingsGroup.this.setEnabledComponent(ProxySettingsGroup.this.host, true);
                    ProxySettingsGroup.this.setEnabledComponent(ProxySettingsGroup.this.port, true);
                    ProxySettingsGroup.this.setEnabledComponent(ProxySettingsGroup.this.vali, false);
                    ProxySettingsGroup.this.setEnabledComponent(ProxySettingsGroup.this.user, true);
                    ProxySettingsGroup.this.setEnabledComponent(ProxySettingsGroup.this.pass, true);
                } else if ("HTTPS".equals(val)) {
                    ProxySettingsGroup.this.setEnabledComponent(ProxySettingsGroup.this.host, true);
                    ProxySettingsGroup.this.setEnabledComponent(ProxySettingsGroup.this.port, true);
                    ProxySettingsGroup.this.setEnabledComponent(ProxySettingsGroup.this.vali, true);
                    ProxySettingsGroup.this.setEnabledComponent(ProxySettingsGroup.this.user, true);
                    ProxySettingsGroup.this.setEnabledComponent(ProxySettingsGroup.this.pass, true);
                } else {
                    ProxySettingsGroup.this.setEnabledComponent(ProxySettingsGroup.this.host, false);
                    ProxySettingsGroup.this.setEnabledComponent(ProxySettingsGroup.this.port, false);
                    ProxySettingsGroup.this.setEnabledComponent(ProxySettingsGroup.this.vali, false);
                    ProxySettingsGroup.this.setEnabledComponent(ProxySettingsGroup.this.user, false);
                    ProxySettingsGroup.this.setEnabledComponent(ProxySettingsGroup.this.pass, false);
                }
            }
        }
    }
}

