/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.ifd.scio.wrapper;

import java.lang.reflect.InvocationTargetException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.List;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CardTerminals;
import org.openecard.common.GenericFactoryException;
import org.openecard.common.ifd.TerminalFactory;
import org.openecard.common.util.ExceptionUtils;
import org.openecard.ifd.scio.IFDException;
import org.openecard.ifd.scio.wrapper.IFDTerminalFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeadAndAliveTerminals
extends CardTerminals {
    private static final Logger logger = LoggerFactory.getLogger(DeadAndAliveTerminals.class);
    private static final long WAIT_DELTA = 500L;
    private boolean error;
    private long lastTry;
    private CardTerminals terminals;

    public DeadAndAliveTerminals() throws IFDException {
        this.reloadTerminals();
    }

    private void reloadTerminals() throws IFDException {
        this.lastTry = System.currentTimeMillis();
        try {
            TerminalFactory f = IFDTerminalFactory.getInstance();
            this.terminals = f.terminals();
            this.error = false;
        }
        catch (IFDException ex) {
            NoSuchAlgorithmException destEx = (NoSuchAlgorithmException)ExceptionUtils.matchPath(ex, NoSuchAlgorithmException.class, InvocationTargetException.class, GenericFactoryException.class);
            if (destEx != null && destEx.getCause() != null && destEx.getCause().getClass().getName().endsWith(".PCSCException")) {
                this.error = true;
            }
            throw ex;
        }
    }

    public synchronized boolean isDead() {
        this.tryReloadWhenError();
        return this.error;
    }

    public synchronized boolean isAlive() {
        return !this.isDead();
    }

    private synchronized void tryReloadWhenError() {
        long now = System.currentTimeMillis();
        if (this.error && now - this.lastTry > 500L) {
            try {
                this.reloadTerminals();
            }
            catch (IFDException ex) {
                logger.error("The TerminalFactory has a serious problem.", ex);
            }
        }
    }

    @Override
    public synchronized List<CardTerminal> list(CardTerminals.State state) throws CardException {
        if (this.isDead()) {
            return Collections.emptyList();
        }
        return this.terminals.list(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitForChange(long timeout) throws CardException {
        if (timeout < 0L) {
            throw new IllegalArgumentException("Timeout is negative.");
        }
        if (timeout == 0L) {
            timeout = Long.MAX_VALUE;
        }
        long start = System.currentTimeMillis();
        while (this.isDead() && System.currentTimeMillis() - start < timeout) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ex) {}
        }
        DeadAndAliveTerminals deadAndAliveTerminals = this;
        synchronized (deadAndAliveTerminals) {
            if (this.isDead()) {
                return false;
            }
            return this.terminals.waitForChange(timeout);
        }
    }
}

