/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.pqc.math.linearalgebra;

import org.openecard.bouncycastle.pqc.math.linearalgebra.GF2mField;
import org.openecard.bouncycastle.pqc.math.linearalgebra.IntUtils;
import org.openecard.bouncycastle.pqc.math.linearalgebra.Permutation;
import org.openecard.bouncycastle.pqc.math.linearalgebra.Vector;

public class GF2mVector
extends Vector {
    private GF2mField field;
    private int[] vector;

    public GF2mVector(GF2mField field, byte[] v) {
        int d;
        this.field = new GF2mField(field);
        int count = 1;
        for (d = 8; field.getDegree() > d; d += 8) {
            ++count;
        }
        if (v.length % count != 0) {
            throw new IllegalArgumentException("Byte array is not an encoded vector over the given finite field.");
        }
        this.length = v.length / count;
        this.vector = new int[this.length];
        count = 0;
        for (int i = 0; i < this.vector.length; ++i) {
            for (int j = 0; j < d; j += 8) {
                int n = i;
                this.vector[n] = this.vector[n] | (v[count++] & 0xFF) << j;
            }
            if (field.isElementOfThisField(this.vector[i])) continue;
            throw new IllegalArgumentException("Byte array is not an encoded vector over the given finite field.");
        }
    }

    public GF2mVector(GF2mField field, int[] vector) {
        this.field = field;
        this.length = vector.length;
        for (int i = vector.length - 1; i >= 0; --i) {
            if (field.isElementOfThisField(vector[i])) continue;
            throw new ArithmeticException("Element array is not specified over the given finite field.");
        }
        this.vector = IntUtils.clone(vector);
    }

    public GF2mVector(GF2mVector other) {
        this.field = new GF2mField(other.field);
        this.length = other.length;
        this.vector = IntUtils.clone(other.vector);
    }

    public GF2mField getField() {
        return this.field;
    }

    public int[] getIntArrayForm() {
        return IntUtils.clone(this.vector);
    }

    @Override
    public byte[] getEncoded() {
        int d;
        int count = 1;
        for (d = 8; this.field.getDegree() > d; d += 8) {
            ++count;
        }
        byte[] res = new byte[this.vector.length * count];
        count = 0;
        for (int i = 0; i < this.vector.length; ++i) {
            for (int j = 0; j < d; j += 8) {
                res[count++] = (byte)(this.vector[i] >>> j);
            }
        }
        return res;
    }

    @Override
    public boolean isZero() {
        for (int i = this.vector.length - 1; i >= 0; --i) {
            if (this.vector[i] == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public Vector add(Vector addend) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public Vector multiply(Permutation p) {
        int[] pVec = p.getVector();
        if (this.length != pVec.length) {
            throw new ArithmeticException("permutation size and vector size mismatch");
        }
        int[] result = new int[this.length];
        for (int i = 0; i < pVec.length; ++i) {
            result[i] = this.vector[pVec[i]];
        }
        return new GF2mVector(this.field, result);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof GF2mVector)) {
            return false;
        }
        GF2mVector otherVec = (GF2mVector)other;
        if (!this.field.equals(otherVec.field)) {
            return false;
        }
        return IntUtils.equals(this.vector, otherVec.vector);
    }

    @Override
    public int hashCode() {
        int hash = this.field.hashCode();
        hash = hash * 31 + this.vector.hashCode();
        return hash;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.vector.length; ++i) {
            for (int j = 0; j < this.field.getDegree(); ++j) {
                int r = j & 0x1F;
                int bitMask = 1 << r;
                int coeff = this.vector[i] & bitMask;
                if (coeff != 0) {
                    buf.append('1');
                    continue;
                }
                buf.append('0');
            }
            buf.append(' ');
        }
        return buf.toString();
    }
}

