/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.crypto.tls;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.openecard.bouncycastle.asn1.ASN1Primitive;
import org.openecard.bouncycastle.asn1.x500.X500Name;
import org.openecard.bouncycastle.crypto.tls.TlsUtils;

public class CertificateRequest {
    private short[] certificateTypes;
    private Vector certificateAuthorities;

    public CertificateRequest(short[] certificateTypes, Vector certificateAuthorities) {
        this.certificateTypes = certificateTypes;
        this.certificateAuthorities = certificateAuthorities;
    }

    public short[] getCertificateTypes() {
        return this.certificateTypes;
    }

    public Vector getCertificateAuthorities() {
        return this.certificateAuthorities;
    }

    public void encode(OutputStream output) throws IOException {
        if (this.certificateTypes == null || this.certificateTypes.length == 0) {
            TlsUtils.writeUint8((short)0, output);
        } else {
            TlsUtils.writeUint8((short)this.certificateTypes.length, output);
            TlsUtils.writeUint8Array(this.certificateTypes, output);
        }
        if (this.certificateAuthorities == null || this.certificateAuthorities.isEmpty()) {
            TlsUtils.writeUint16(0, output);
        } else {
            int i;
            Vector<byte[]> encDNs = new Vector<byte[]>(this.certificateAuthorities.size());
            int totalLength = 0;
            for (i = 0; i < this.certificateAuthorities.size(); ++i) {
                X500Name authorityDN = (X500Name)this.certificateAuthorities.elementAt(i);
                byte[] encDN = authorityDN.getEncoded("DER");
                encDNs.addElement(encDN);
                totalLength += encDN.length;
            }
            TlsUtils.writeUint16(totalLength, output);
            for (i = 0; i < encDNs.size(); ++i) {
                byte[] encDN = (byte[])encDNs.elementAt(i);
                output.write(encDN);
            }
        }
    }

    public static CertificateRequest parse(InputStream input) throws IOException {
        int numTypes = TlsUtils.readUint8(input);
        short[] certificateTypes = new short[numTypes];
        for (int i = 0; i < numTypes; ++i) {
            certificateTypes[i] = TlsUtils.readUint8(input);
        }
        byte[] authorities = TlsUtils.readOpaque16(input);
        Vector<X500Name> authorityDNs = new Vector<X500Name>();
        ByteArrayInputStream bis = new ByteArrayInputStream(authorities);
        while (bis.available() > 0) {
            byte[] dnBytes = TlsUtils.readOpaque16(bis);
            authorityDNs.addElement(X500Name.getInstance(ASN1Primitive.fromByteArray(dnBytes)));
        }
        return new CertificateRequest(certificateTypes, authorityDNs);
    }
}

