/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.sal.protocol.eac.anytype;

import iso.std.iso_iec._24727.tech.schema.DIDAuthenticationDataType;
import org.openecard.common.anytype.AuthDataMap;
import org.openecard.common.anytype.AuthDataResponse;
import org.openecard.common.util.ByteUtils;

public class EAC1OutputType {
    public static final String RETRY_COUNTER = "RetryCounter";
    public static final String EF_CARDACCESS = "EFCardAccess";
    public static final String CAR = "CertificationAuthorityReference";
    public static final String CHAT = "CertificateHolderAuthorizationTemplate";
    public static final String ID_PICC = "IDPICC";
    private final AuthDataMap authMap;
    private byte[] efCardAccess;
    private byte[] car;
    private byte[] chat;
    private byte[] idpicc;
    private int retryCounter;

    protected EAC1OutputType(AuthDataMap authMap) {
        this.authMap = authMap;
    }

    public void setEFCardAccess(byte[] efCardAccess) {
        this.efCardAccess = efCardAccess;
    }

    public void setCAR(byte[] car) {
        this.car = car;
    }

    public void setCHAT(byte[] chat) {
        this.chat = chat;
    }

    public void setIDPICC(byte[] idpicc) {
        this.idpicc = idpicc;
    }

    public void setRetryCounter(int retryCounter) {
        this.retryCounter = retryCounter;
    }

    public DIDAuthenticationDataType getAuthDataType() {
        AuthDataResponse authResponse = this.authMap.createResponse(new iso.std.iso_iec._24727.tech.schema.EAC1OutputType());
        authResponse.addElement(RETRY_COUNTER, String.valueOf(this.retryCounter));
        authResponse.addElement(EF_CARDACCESS, ByteUtils.toHexString(this.efCardAccess));
        authResponse.addElement(CAR, new String(this.car));
        authResponse.addElement(CHAT, ByteUtils.toHexString(this.chat));
        authResponse.addElement(ID_PICC, ByteUtils.toHexString(this.idpicc));
        return authResponse.getResponse();
    }
}

