/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.common.asn1.cvc;

import java.math.BigInteger;
import java.util.List;
import org.openecard.common.tlv.TLV;
import org.openecard.crypto.common.asn1.cvc.PublicKey;
import org.openecard.crypto.common.asn1.utils.ObjectIdentifierUtils;

public final class ECPublicKey
extends PublicKey {
    private static final int PRIME_TAG = 129;
    private static final int COEFFICIENT_A_TAG = 130;
    private static final int COEFFICIENT_B_TAG = 131;
    private static final int BASE_POINT_TAG = 132;
    private static final int ORDER_TAG = 133;
    private static final int PUBLIC_POINT_TAG = 134;
    private static final int COFACTOR_TAG = 135;
    private TLV key;
    private String oid;
    private BigInteger prime;
    private BigInteger a;
    private BigInteger b;
    private byte[] g;
    private BigInteger order;
    private byte[] y;
    private BigInteger h;

    protected ECPublicKey(TLV key) throws Exception {
        this.key = key;
        List<TLV> bodyElements = key.getChild().asList();
        for (TLV item : bodyElements) {
            int itemTag = (int)item.getTagNumWithClass();
            switch (itemTag) {
                case 6: {
                    this.oid = ObjectIdentifierUtils.toString(key.findChildTags(6L).get(0).getValue());
                    break;
                }
                case 129: {
                    this.prime = new BigInteger(key.findChildTags(129L).get(0).getValue());
                    break;
                }
                case 130: {
                    this.a = new BigInteger(key.findChildTags(130L).get(0).getValue());
                    break;
                }
                case 131: {
                    this.b = new BigInteger(key.findChildTags(131L).get(0).getValue());
                    break;
                }
                case 132: {
                    this.g = key.findChildTags(132L).get(0).getValue();
                    break;
                }
                case 133: {
                    this.order = new BigInteger(key.findChildTags(133L).get(0).getValue());
                    break;
                }
                case 134: {
                    this.y = key.findChildTags(134L).get(0).getValue();
                    break;
                }
                case 135: {
                    this.h = new BigInteger(key.findChildTags(135L).get(0).getValue());
                    break;
                }
            }
        }
        this.verify();
    }

    private void verify() {
        if (this.oid == null || this.y == null) {
            throw new IllegalArgumentException("Malformed ECPublicKey");
        }
        if (!(this.prime != null && this.a != null && this.b != null && this.g != null && this.order != null || this.prime == null && this.a == null && this.b == null && this.g == null && this.order == null)) {
            throw new IllegalArgumentException("Malformed ECPublicKey");
        }
    }

    @Override
    public TLV getTLVEncoded() {
        return this.key;
    }

    public BigInteger getA() {
        return this.a;
    }

    public BigInteger getB() {
        return this.b;
    }

    public BigInteger getCofactor() {
        return this.h;
    }

    @Override
    public String getObjectIdentifier() {
        return this.oid;
    }

    public BigInteger getOrder() {
        return this.order;
    }

    public BigInteger getPrime() {
        return this.prime;
    }

    public byte[] getY() {
        return this.y;
    }

    public byte[] getBasePoint() {
        return this.g;
    }
}

