/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.control.module.tctoken;

import generated.TCTokenType;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.openecard.common.io.LimitedInputStream;
import org.openecard.control.module.tctoken.TCTokenException;
import org.openecard.control.module.tctoken.TCTokenSAXHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.helpers.DefaultHandler;

public class TCTokenParser {
    private static final Logger _logger = LoggerFactory.getLogger(TCTokenParser.class);
    private SAXParserFactory saxFactory = SAXParserFactory.newInstance();
    private TCTokenSAXHandler saxHandler = new TCTokenSAXHandler();

    public TCTokenParser() {
        try {
            this.saxFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (Exception e) {
            _logger.error(e.getMessage(), e);
        }
    }

    public List<TCTokenType> parse(String data) throws TCTokenException {
        return this.parse(new ByteArrayInputStream(data.getBytes()));
    }

    public List<TCTokenType> parse(InputStream inputStream) throws TCTokenException {
        try {
            SAXParser saxParser = this.saxFactory.newSAXParser();
            LimitedInputStream stream = new LimitedInputStream(inputStream);
            saxParser.parse((InputStream)stream, (DefaultHandler)this.saxHandler);
            List<TCTokenType> tokens = this.saxHandler.getTCTokens();
            return tokens;
        }
        catch (Exception e) {
            _logger.error(e.getMessage(), e);
            throw new TCTokenException("TCToken is malformed", e);
        }
    }
}

