/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.control.module.tctoken;

import generated.TCTokenType;
import iso.std.iso_iec._24727.tech.schema.CardApplicationDisconnect;
import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import iso.std.iso_iec._24727.tech.schema.StartPAOS;
import iso.std.iso_iec._24727.tech.schema.StartPAOSResponse;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.Callable;
import org.openecard.bouncycastle.crypto.tls.AbstractTlsClient;
import org.openecard.bouncycastle.crypto.tls.ProtocolVersion;
import org.openecard.common.DynamicContext;
import org.openecard.common.interfaces.Dispatcher;
import org.openecard.common.interfaces.DispatcherException;
import org.openecard.control.module.tctoken.TCTokenRequest;
import org.openecard.crypto.tls.ClientCertDefaultTlsClient;
import org.openecard.crypto.tls.ClientCertPSKTlsClient;
import org.openecard.crypto.tls.TlsNoAuthentication;
import org.openecard.crypto.tls.TlsPSKIdentityImpl;
import org.openecard.transport.paos.PAOS;
import org.openecard.transport.paos.PAOSException;

public class PAOSTask
implements Callable<StartPAOSResponse> {
    private final Dispatcher dispatcher;
    private final ConnectionHandleType connectionHandle;
    private final TCTokenRequest tokenRequest;

    public PAOSTask(Dispatcher dispatcher, ConnectionHandleType connectionHandle, TCTokenRequest tokenRequest) {
        this.dispatcher = dispatcher;
        this.connectionHandle = connectionHandle;
        this.tokenRequest = tokenRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartPAOSResponse call() throws MalformedURLException, PAOSException, DispatcherException, InvocationTargetException {
        TCTokenType token = this.tokenRequest.getTCToken();
        try {
            AbstractTlsClient tlsClient;
            TlsNoAuthentication tlsAuth;
            String cardType = null;
            if (this.connectionHandle.getRecognitionInfo() != null) {
                cardType = this.connectionHandle.getRecognitionInfo().getCardType();
            }
            if (cardType == null) {
                cardType = this.tokenRequest.getCardType();
            }
            boolean noSni = "http://bsi.bund.de/cif/npa.xml".equals(cardType);
            String sessionIdentifier = token.getSessionIdentifier();
            URL serverAddress = new URL(token.getServerAddress());
            String serverHost = serverAddress.getHost();
            String secProto = token.getPathSecurityProtocol();
            String queryPart = serverAddress.getQuery();
            if (queryPart == null || !queryPart.contains("?sessionid=") && !queryPart.contains("&sessionid=")) {
                String sAddr = serverAddress.toString();
                if (serverAddress.getPath().isEmpty()) {
                    sAddr = sAddr + "/";
                }
                sAddr = sAddr.endsWith("?") ? sAddr + "sessionid=" + sessionIdentifier : (sAddr.contains("?") ? sAddr + "&sessionid=" + sessionIdentifier : sAddr + "?sessionid=" + sessionIdentifier);
                serverAddress = new URL(sAddr);
            }
            if (secProto.equals("urn:ietf:rfc:4279") || secProto.equals("urn:ietf:rfc:5487")) {
                tlsAuth = new TlsNoAuthentication();
                tlsAuth.setHostname(serverHost);
                byte[] psk = token.getPathSecurityParameters().getPSK();
                TlsPSKIdentityImpl pskId = new TlsPSKIdentityImpl(sessionIdentifier.getBytes(), psk);
                tlsClient = new ClientCertPSKTlsClient(pskId, noSni ? null : serverHost);
                tlsClient.setAuthentication(tlsAuth);
                tlsClient.setClientVersion(ProtocolVersion.TLSv11);
            } else if (secProto.equals("urn:ietf:rfc:4346")) {
                tlsAuth = new TlsNoAuthentication();
                tlsAuth.setHostname(serverHost);
                tlsClient = new ClientCertDefaultTlsClient(noSni ? null : serverHost);
                tlsClient.setAuthentication(tlsAuth);
                tlsClient.setClientVersion(ProtocolVersion.TLSv11);
            } else {
                throw new PAOSException("Unknow security protocol '" + secProto + "' requested.");
            }
            if (serverAddress.getProtocol().equals("http")) {
                tlsClient = null;
            }
            PAOS p = new PAOS(serverAddress, this.dispatcher, tlsClient);
            StartPAOS sp = new StartPAOS();
            sp.setProfile("http://www.bsi.bund.de/ecard/api/1.1");
            sp.getConnectionHandle().add(this.connectionHandle);
            sp.setSessionIdentifier(sessionIdentifier);
            StartPAOSResponse startPAOSResponse = p.sendStartPAOS(sp);
            return startPAOSResponse;
        }
        finally {
            CardApplicationDisconnect appDis = new CardApplicationDisconnect();
            appDis.setConnectionHandle(this.connectionHandle);
            this.dispatcher.deliver(appDis);
            DynamicContext dynCtx = DynamicContext.getInstance("tr03112");
            Object objectActivation = dynCtx.get("object_activation");
            if (objectActivation instanceof Boolean && ((Boolean)objectActivation).booleanValue()) {
                dynCtx.clear();
            }
        }
    }
}

