/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.crypto.tls;

import java.io.IOException;
import java.security.SecureRandom;
import org.openecard.bouncycastle.crypto.BlockCipher;
import org.openecard.bouncycastle.crypto.Digest;
import org.openecard.bouncycastle.crypto.params.KeyParameter;
import org.openecard.bouncycastle.crypto.params.ParametersWithIV;
import org.openecard.bouncycastle.crypto.tls.ProtocolVersion;
import org.openecard.bouncycastle.crypto.tls.TlsCipher;
import org.openecard.bouncycastle.crypto.tls.TlsClientContext;
import org.openecard.bouncycastle.crypto.tls.TlsFatalAlert;
import org.openecard.bouncycastle.crypto.tls.TlsMac;
import org.openecard.bouncycastle.crypto.tls.TlsUtils;
import org.openecard.bouncycastle.util.Arrays;

public class TlsBlockCipher
implements TlsCipher {
    protected TlsClientContext context;
    protected BlockCipher encryptCipher;
    protected BlockCipher decryptCipher;
    protected TlsMac writeMac;
    protected TlsMac readMac;

    public TlsMac getWriteMac() {
        return this.writeMac;
    }

    public TlsMac getReadMac() {
        return this.readMac;
    }

    public TlsBlockCipher(TlsClientContext context, BlockCipher encryptCipher, BlockCipher decryptCipher, Digest writeDigest, Digest readDigest, int cipherKeySize) {
        this.context = context;
        this.encryptCipher = encryptCipher;
        this.decryptCipher = decryptCipher;
        int key_block_size = 2 * cipherKeySize + writeDigest.getDigestSize() + readDigest.getDigestSize() + encryptCipher.getBlockSize() + decryptCipher.getBlockSize();
        byte[] key_block = TlsUtils.calculateKeyBlock(context, key_block_size);
        int offset = 0;
        this.writeMac = new TlsMac(context, writeDigest, key_block, offset, writeDigest.getDigestSize());
        this.readMac = new TlsMac(context, readDigest, key_block, offset += writeDigest.getDigestSize(), readDigest.getDigestSize());
        this.initCipher(true, encryptCipher, key_block, cipherKeySize, offset += readDigest.getDigestSize(), offset + cipherKeySize * 2);
        this.initCipher(false, decryptCipher, key_block, cipherKeySize, offset += cipherKeySize, offset + cipherKeySize + encryptCipher.getBlockSize());
    }

    protected void initCipher(boolean forEncryption, BlockCipher cipher, byte[] key_block, int key_size, int key_offset, int iv_offset) {
        KeyParameter key_parameter = new KeyParameter(key_block, key_offset, key_size);
        ParametersWithIV parameters_with_iv = new ParametersWithIV(key_parameter, key_block, iv_offset, cipher.getBlockSize());
        cipher.init(forEncryption, parameters_with_iv);
    }

    @Override
    public byte[] encodePlaintext(short type, byte[] plaintext, int offset, int len) {
        int i;
        int minPaddingSize;
        int blocksize = this.encryptCipher.getBlockSize();
        boolean isTls = this.context.getServerVersion().getFullVersion() >= ProtocolVersion.TLSv10.getFullVersion();
        byte[] mac = this.writeMac.calculateMac(type, plaintext, offset, len);
        if (this.context.getServerVersion().getFullVersion() >= ProtocolVersion.TLSv11.getFullVersion()) {
            byte[] prefix = new byte[blocksize];
            byte[] prefixedPlaintext = new byte[plaintext.length + prefix.length];
            this.context.getSecureRandom().nextBytes(prefix);
            System.arraycopy(plaintext, offset, prefixedPlaintext, offset + prefix.length, len);
            System.arraycopy(prefix, 0, prefixedPlaintext, offset, prefix.length);
            plaintext = prefixedPlaintext;
            len += prefix.length;
        }
        int paddingSize = minPaddingSize = blocksize - (len + this.writeMac.getSize() + 1) % blocksize;
        if (isTls) {
            int maxExtraPadBlocks = (255 - minPaddingSize) / blocksize;
            int actualExtraPadBlocks = this.chooseExtraPadBlocks(this.context.getSecureRandom(), maxExtraPadBlocks);
            paddingSize += actualExtraPadBlocks * blocksize;
        }
        int totalsize = len + this.writeMac.getSize() + paddingSize + 1;
        byte[] outbuf = new byte[totalsize];
        System.arraycopy(plaintext, offset, outbuf, 0, len);
        System.arraycopy(mac, 0, outbuf, len, mac.length);
        int paddoffset = len + mac.length;
        for (i = 0; i <= paddingSize; ++i) {
            outbuf[i + paddoffset] = (byte)paddingSize;
        }
        for (i = 0; i < totalsize; i += blocksize) {
            this.encryptCipher.processBlock(outbuf, i, outbuf, i);
        }
        return outbuf;
    }

    @Override
    public byte[] decodeCiphertext(short type, byte[] ciphertext, int offset, int len) throws IOException {
        int minLength = this.readMac.getSize() + 1;
        int blocksize = this.decryptCipher.getBlockSize();
        boolean decrypterror = false;
        if (len < minLength) {
            throw new TlsFatalAlert(50);
        }
        if (len % blocksize != 0) {
            throw new TlsFatalAlert(21);
        }
        for (int i = 0; i < len; i += blocksize) {
            this.decryptCipher.processBlock(ciphertext, i + offset, ciphertext, i + offset);
        }
        int lastByteOffset = offset + len - 1;
        byte paddingsizebyte = ciphertext[lastByteOffset];
        int paddingsize = paddingsizebyte & 0xFF;
        boolean isTls = this.context.getServerVersion().getFullVersion() >= ProtocolVersion.TLSv10.getFullVersion();
        int maxPaddingSize = len - minLength;
        if (!isTls) {
            maxPaddingSize = Math.min(maxPaddingSize, blocksize);
        }
        if (paddingsize > maxPaddingSize) {
            decrypterror = true;
            paddingsize = 0;
        } else if (isTls) {
            int diff = 0;
            for (int i = lastByteOffset - paddingsize; i < lastByteOffset; ++i) {
                diff = (byte)(diff | ciphertext[i] ^ paddingsizebyte);
            }
            if (diff != 0) {
                decrypterror = true;
                paddingsize = 0;
            }
        }
        int plaintextlength = len - minLength - paddingsize;
        if (this.context.getServerVersion().getFullVersion() >= ProtocolVersion.TLSv11.getFullVersion()) {
            plaintextlength -= this.decryptCipher.getBlockSize();
            offset += this.decryptCipher.getBlockSize();
        }
        byte[] calculatedMac = this.readMac.calculateMac(type, ciphertext, offset, plaintextlength);
        byte[] decryptedMac = new byte[calculatedMac.length];
        System.arraycopy(ciphertext, offset + plaintextlength, decryptedMac, 0, calculatedMac.length);
        if (!Arrays.constantTimeAreEqual(calculatedMac, decryptedMac)) {
            decrypterror = true;
        }
        if (decrypterror) {
            throw new TlsFatalAlert(20);
        }
        byte[] plaintext = new byte[plaintextlength];
        System.arraycopy(ciphertext, offset, plaintext, 0, plaintextlength);
        return plaintext;
    }

    protected int chooseExtraPadBlocks(SecureRandom r, int max) {
        int x = r.nextInt();
        int n = this.lowestBitSet(x);
        return Math.min(n, max);
    }

    protected int lowestBitSet(int x) {
        if (x == 0) {
            return 32;
        }
        int n = 0;
        while ((x & 1) == 0) {
            ++n;
            x >>= 1;
        }
        return n;
    }
}

