/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.richclient.gui.manage;

import java.awt.Component;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.swing.AbstractListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openecard.richclient.gui.manage.AddonPanel;
import org.openecard.richclient.gui.manage.ManagementDialog;

public class AddonSelectionModel
extends AbstractListModel<String>
implements ListSelectionListener,
WindowListener {
    private static final long serialVersionUID = 1L;
    private int idxCounter;
    private final ManagementDialog dialog;
    private final JPanel container;
    private final HashMap<Integer, String> names;
    private final HashMap<Integer, AddonPanel> addons;
    private final HashMap<Integer, Class<AddonPanel>> addonClasses;
    private AddonPanel lastActivePanel;

    public AddonSelectionModel(ManagementDialog dialog, JPanel container) {
        this.dialog = dialog;
        this.container = container;
        this.names = new HashMap();
        this.addons = new HashMap();
        this.addonClasses = new HashMap();
    }

    public synchronized void addElement(@Nonnull String name, @Nonnull AddonPanel addonPanel) {
        if (!this.names.containsValue(name)) {
            this.names.put(this.idxCounter, name);
            this.addons.put(this.idxCounter, addonPanel);
            ++this.idxCounter;
        }
    }

    public synchronized void addElement(@Nonnull String name, @Nonnull Class<AddonPanel> addonPanel) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public int getSize() {
        return this.names.size();
    }

    @Override
    public String getElementAt(int index) {
        return this.names.get(index);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Object source = e.getSource();
        if (!e.getValueIsAdjusting() && source instanceof JList) {
            JList sourceList = (JList)source;
            this.saveLastDialog();
            int idx = sourceList.getSelectedIndex();
            if (idx >= 0) {
                AddonPanel panel;
                this.lastActivePanel = panel = this.getPanel(idx);
                this.container.removeAll();
                this.container.add((Component)panel, "Center");
                this.container.invalidate();
                this.container.validate();
                this.container.repaint();
                this.dialog.setLogo(panel.getIcon());
            }
        }
    }

    private synchronized AddonPanel getPanel(int idx) {
        return this.addons.get(idx);
    }

    private void saveLastDialog() {
        if (this.lastActivePanel != null) {
            this.lastActivePanel.saveProperties();
            this.lastActivePanel = null;
        }
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
        this.saveLastDialog();
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }
}

