/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.common.asn1.cvc;

import org.openecard.common.util.ByteUtils;

public class PublicKeyReference {
    private byte[] reference;
    private String countryCode;
    private String holderMnemonic;
    private String sequenceNumber;

    public PublicKeyReference(String reference) {
        this(reference.getBytes());
    }

    public PublicKeyReference(byte[] reference) {
        this.reference = reference;
        this.parse();
    }

    private void parse() {
        int length = this.reference.length;
        this.countryCode = new String(ByteUtils.copy(this.reference, 0, 2));
        this.holderMnemonic = new String(ByteUtils.copy(this.reference, 2, length - 7));
        this.sequenceNumber = new String(ByteUtils.copy(this.reference, length - 5, 5));
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public String getHolderMnemonic() {
        return this.holderMnemonic;
    }

    public String getSequenceNumber() {
        return this.sequenceNumber;
    }

    public byte[] toByteArray() {
        return this.reference;
    }

    public boolean compare(PublicKeyReference publicKeyReference) {
        return this.compare(publicKeyReference.toByteArray());
    }

    public boolean compare(byte[] publicKeyReference) {
        return ByteUtils.compare(this.reference, publicKeyReference);
    }

    public String toHexString() {
        return ByteUtils.toHexString(this.reference, true);
    }

    public String toString() {
        return new String(this.reference);
    }
}

