/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.jcajce.provider.asymmetric.rsa;

import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import org.openecard.bouncycastle.crypto.AsymmetricBlockCipher;
import org.openecard.bouncycastle.crypto.Digest;
import org.openecard.bouncycastle.crypto.digests.MD5Digest;
import org.openecard.bouncycastle.crypto.digests.RIPEMD160Digest;
import org.openecard.bouncycastle.crypto.digests.SHA1Digest;
import org.openecard.bouncycastle.crypto.engines.RSABlindedEngine;
import org.openecard.bouncycastle.crypto.params.RSAKeyParameters;
import org.openecard.bouncycastle.crypto.signers.ISO9796d2Signer;
import org.openecard.bouncycastle.jcajce.provider.asymmetric.rsa.RSAUtil;

public class ISOSignatureSpi
extends SignatureSpi {
    private ISO9796d2Signer signer;

    protected ISOSignatureSpi(Digest digest, AsymmetricBlockCipher cipher) {
        this.signer = new ISO9796d2Signer(cipher, digest, true);
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        RSAKeyParameters param = RSAUtil.generatePublicKeyParameter((RSAPublicKey)publicKey);
        this.signer.init(false, param);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        RSAKeyParameters param = RSAUtil.generatePrivateKeyParameter((RSAPrivateKey)privateKey);
        this.signer.init(true, param);
    }

    @Override
    protected void engineUpdate(byte b) throws SignatureException {
        this.signer.update(b);
    }

    @Override
    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        this.signer.update(b, off, len);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        try {
            byte[] sig = this.signer.generateSignature();
            return sig;
        }
        catch (Exception e) {
            throw new SignatureException(e.toString());
        }
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        boolean yes = this.signer.verifySignature(sigBytes);
        return yes;
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec params) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected void engineSetParameter(String param, Object value) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected Object engineGetParameter(String param) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    public static class RIPEMD160WithRSAEncryption
    extends ISOSignatureSpi {
        public RIPEMD160WithRSAEncryption() {
            super(new RIPEMD160Digest(), new RSABlindedEngine());
        }
    }

    public static class MD5WithRSAEncryption
    extends ISOSignatureSpi {
        public MD5WithRSAEncryption() {
            super(new MD5Digest(), new RSABlindedEngine());
        }
    }

    public static class SHA1WithRSAEncryption
    extends ISOSignatureSpi {
        public SHA1WithRSAEncryption() {
            super(new SHA1Digest(), new RSABlindedEngine());
        }
    }
}

